% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchSCAN.R
\name{fetchSCAN}
\alias{fetchSCAN}
\alias{SCAN_sensor_metadata}
\alias{SCAN_site_metadata}
\title{Get Daily Climate Data from USDA-NRCS SCAN (Soil Climate Analysis Network) Stations}
\usage{
fetchSCAN(
  site.code = NULL,
  year = NULL,
  report = "SCAN",
  timeseries = c("Daily", "Hourly"),
  ...
)

SCAN_sensor_metadata(site.code)

SCAN_site_metadata(site.code = NULL)
}
\arguments{
\item{site.code}{a vector of site codes. If \code{NULL} \code{SCAN_site_metadata()} returns metadata for all SCAN sites.}

\item{year}{a vector of years}

\item{report}{report name, single value only; default \code{'SCAN'}, other example options include individual sensor codes, e.g. \code{'SMS'} for Soil Moisture Storage, \code{'TEMP'} for temperature}

\item{timeseries}{either \code{'Daily'} or \code{'Hourly'}}

\item{...}{additional arguments. May include \code{intervalType}, \code{format}, \code{sitenum}, \code{interval}, \code{year}, \code{month}. Presence of additional arguments bypasses default batching functionality provided in the function and submits a 'raw' request to the API form.}
}
\value{
a \code{list} of \code{data.frame} objects, where each element name is a sensor type, plus a \code{metadata} table; different \code{report} types change the types of sensor data returned. \code{SCAN_sensor_metadata()} and \code{SCAN_site_metadata()} return a \code{data.frame}. \code{NULL} on bad request.
}
\description{
Query soil/climate data from USDA-NRCS SCAN Stations.
}
\details{
Possible above and below ground sensor types include: 'SMS' (soil moisture), 'STO' (soil temperature), 'SAL' (salinity), 'TAVG' (daily average air temperature), 'TMIN' (daily minimum air temperature), 'TMAX' (daily maximum air temperature), 'PRCP' (daily precipitation), 'PREC' (daily precipitation), 'SNWD' (snow depth), 'WTEQ' (snow water equivalent),'WDIRV' (wind direction), 'WSPDV' (wind speed), 'LRADT' (solar radiation/langley total).

This function converts below-ground sensor depth from inches to cm. All temperature values are reported as degrees C. Precipitation, snow depth, and snow water content are reported as \emph{inches}.
\subsection{SCAN Sensors}{

All Soil Climate Analysis Network (SCAN) sensor measurements are reported hourly.\tabular{lll}{
   Element Measured \tab Sensor Type \tab Precision \cr
   Air Temperature \tab Shielded thermistor \tab 0.1 degrees C \cr
   Barometric Pressure \tab Silicon capacitive pressure sensor \tab 1\% \cr
   Precipitation \tab Storage-type gage or tipping bucket \tab Storage: 0.1 inches; \cr
   Relative Humidity \tab Thin film capacitance-type sensor \tab 1\% \cr
   Snow Depth \tab Sonic sensor (not on all stations) \tab 0.5 inches \cr
   Snow Water Content \tab Snow pillow device and a pressure transducer (not on all stations) \tab 0.1 inches \cr
   Soil Moisture \tab Dielectric constant measuring device. Typical measurements are at 2", 4", 8", 20", and 40" where possible. \tab 0.50\% \cr
   Soil Temperature \tab Encapsulated thermistor. Typical measurements are at 2", 4", 8", 20", and 40" where possible. \tab 0.1 degrees C \cr
   Solar Radiation \tab Pyranometer \tab 0.01 watts per meter \cr
   Wind Speed and Direction \tab Propellor-type anemometer \tab Speed: 0.1 miles per hour; Direction: 1 degree \cr
}

}

\subsection{SNOTEL Sensors}{

All Snow Telemetry (SNOTEL) sensor measurements are reported daily.\tabular{lll}{
   Element Measured \tab Sensor Type \tab Precision \cr
   Air Temperature \tab Shielded thermistor \tab 0.1 degrees C \cr
   Barometric Pressure \tab Silicon capacitive pressure sensor \tab 1\% \cr
   Precipitation \tab Storage-type gage or tipping bucket \tab Storage: 0.1 inches; Tipping bucket: 0.01 inches \cr
   Relative Humidity \tab Thin film capacitance-type sensor \tab 1\% \cr
   Snow Depth \tab Sonic sensor \tab 0.5 inches \cr
   Snow Water Content \tab Snow pillow device and a pressure transducer \tab 0.1 inches \cr
   Soil Moisture \tab Dielectric constant measuring device. Typical measurements are at 2", 4", 8", 20", and 40" where possible. \tab 0.50\% \cr
   Soil Temperature \tab Encapsulated thermistor. Typical measurements are at 2", 4", 8", 20", and 40" where possible. \tab 0.1 degrees C \cr
   Solar Radiation \tab Pyranometer \tab 0.01 watts per meter \cr
   Wind Speed and Direction \tab Propellor-type anemometer \tab Speed: 0.1 miles per hour; Direction: 1 degree \cr
}


See the \href{http://ncss-tech.github.io/AQP/soilDB/fetchSCAN-demo.html}{fetchSCAN tutorial} for additional usage and visualization examples.
}
}
\examples{
\dontrun{
    # get data
    x <- try(fetchSCAN(site.code=c(356, 2072), year=c(2015, 2016)))
    str(x)

    # get sensor metadata
    m <- SCAN_sensor_metadata(site.code=c(356, 2072))

    # get site metadata
    m <- SCAN_site_metadata(site.code=c(356, 2072))

    # get hourly data (396315 records)
    # x <- try(fetchSCAN(site.code=c(356, 2072), year=c(2015, 2016), timeseries = "Hourly"))
}
}
\references{
See the \href{https://www.nrcs.usda.gov/resources/data-and-reports/soil-climate-analysis-network}{Soil Climate Analysis Network} home page for more information on the SCAN program,  and links to other associated programs such as SNOTEL, at the National Weather and Climate Center. You can get information on available web services, as well as interactive maps of snow water equivalent, precipitation and streamflow.
}
\author{
D.E. Beaudette, A.G. Brown
}
\keyword{manip}
