% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SDA_muaggatt.R
\name{get_SDA_muaggatt}
\alias{get_SDA_muaggatt}
\title{Get map unit aggregate attribute information from Soil Data Access}
\usage{
get_SDA_muaggatt(
  areasymbols = NULL,
  mukeys = NULL,
  WHERE = NULL,
  query_string = FALSE,
  dsn = NULL
)
}
\arguments{
\item{areasymbols}{vector of soil survey area symbols}

\item{mukeys}{vector of map unit keys}

\item{WHERE}{character containing SQL WHERE clause specified in terms of fields in \code{legend}, \code{mapunit}, or \code{muaggatt} tables, used in lieu of \code{mukeys} or \code{areasymbols}}

\item{query_string}{Default: \code{FALSE}; if \code{TRUE} return a character string containing query that would be sent to SDA via \code{SDA_query}}

\item{dsn}{Path to local SQLite database or a DBIConnection object. If \code{NULL} (default) use Soil Data Access API via \code{SDA_query()}.}
}
\value{
a data.frame
}
\description{
Get map unit aggregate attribute information from Soil Data Access
}
\author{
Jason Nemecek, Chad Ferguson, Andrew Brown
}
