% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilColorWCS.R
\name{soilColor.wcs}
\alias{soilColor.wcs}
\title{Get 30m or 270m gridded soil soil color data from SoilWeb Web Coverage Service (WCS)}
\usage{
soilColor.wcs(aoi, var, res = 270, quiet = FALSE)
}
\arguments{
\item{aoi}{area of interest (AOI) defined using a \code{Spatial*}, \code{RasterLayer}, \code{sf}, \code{sfc} or \code{bbox} object, OR a \code{list}, see details}

\item{var}{soil color grid name (case insensitive), see details}

\item{res}{grid resolution, units of meters, typically '270', or '30', depending on \code{var}. See details.}

\item{quiet}{logical, passed to \code{curl::curl_download} to enable / suppress URL and progress bar for download.}
}
\value{
A \code{SpatRaster} (or \code{RasterLayer}) object containing indexed map unit keys and associated raster attribute table or a try-error if request fails. By default, spatial classes from the \code{terra} package are returned. If the input object class is from the \code{raster} or \code{sp} packages a \code{RasterLayer} is returned.
}
\description{
Moist soil colors, 2022.
}
\details{
\code{aoi} should be specified as a \code{SpatRaster}, \code{Spatial*}, \code{RasterLayer}, \code{SpatRaster}/\code{SpatVector}, \code{sf}, \code{sfc}, or \code{bbox} object or a \code{list} containing:

\describe{
\item{\code{aoi}}{bounding-box specified as (xmin, ymin, xmax, ymax) e.g. c(-114.16, 47.65, -114.08, 47.68)}
\item{\code{crs}}{coordinate reference system of BBOX, e.g. 'OGC:CRS84' (EPSG:4326, WGS84 Longitude/Latitude)}
}

The WCS query is parameterized using a rectangular extent derived from the above AOI specification, after conversion to the native CRS (EPSG:5070) of the soil color grids.

Variables available from this WCS can be queried using \code{WCS_details(wcs = 'soilColor')}. The full resolution version of the soil color grids use a \code{hr} suffix, e.g. 'sc025cm_hr'.
}
\examples{
\dontrun{
library(terra)

# see WCS_details() for variable options
WCS_details(wcs = 'soilColor')

# moist soil color at 25cm, 270m version
res <- soilColor.wcs(list(aoi = c(-116, 35, -115.5, 35.5), crs = "EPSG:4326"), 
                   var = 'sc025cm', res = 270)

# note colors and other metadata are stored
# in raster attribute table
plot(res, col = cats(res)[[1]]$col, axes = FALSE, legend = FALSE)
}
}
\author{
D.E. Beaudette and A.G. Brown
}
