G0dm = c(2.766, 3.491, 4.494, 5.912, 6.989, 7.742, 7.919, 7.027, 5.369, 3.562, 2.814, 2.179)*1000
Ta = c(10, 14.1, 15.6, 17.2, 19.3, 21.2, 28.4, 29.9, 24.3, 18.2, 17.2, 15.2)
gef <- calcGef(lat = 37.2, dataRad = list(G0dm = G0dm, Ta = Ta, year = 2023))
gefI <- as.data.tableI(gef)
gefD <- as.data.tableD(gef)
gefM <- as.data.tableM(gef)
gefY <- as.data.tableY(gef)
gefI_expected <- read.csv('files/gef.csv', sep = ';')
gefD_expected <- read.csv('files/gef.D.csv', sep = ';')
gefM_expected <- read.csv('files/gef.M.csv', sep = ';')
gefY_expected <- read.csv('files/gef.Y.csv', sep = ';')

test_that('Irradiation and irradiance on the generator plane', {
    expect_equal(gefI$Gef, gefI_expected$Gef)
    expect_equal(gefI$Bef, gefI_expected$Bef)
    expect_equal(gefI$Def, gefI_expected$Def)
    expect_equal(gefD$Gefd, gefD_expected$Gefd) 
    expect_equal(gefD$Defd, gefD_expected$Defd)
    expect_equal(gefD$Befd, gefD_expected$Befd)
    expect_equal(gefM$Bod, gefM_expected$Bod)
    expect_equal(gefM$Bnd, gefM_expected$Bnd)
    expect_equal(gefM$Gd, gefM_expected$Gd)
    expect_equal(gefM$Dd, gefM_expected$Dd)
    expect_equal(gefM$Bd, gefM_expected$Bd)
    expect_equal(gefM$Gefd, gefM_expected$Gefd)
    expect_equal(gefM$Defd, gefM_expected$Defd)
    expect_equal(gefM$Befd, gefM_expected$Befd)
    expect_equal(gefY$Bod, gefY_expected$Bod)
    expect_equal(gefY$Bnd, gefY_expected$Bnd)
    expect_equal(gefY$Gd, gefY_expected$Gd)
    expect_equal(gefY$Dd, gefY_expected$Dd)
    expect_equal(gefY$Bd, gefY_expected$Bd)
    expect_equal(gefY$Gefd, gefY_expected$Gefd)
    expect_equal(gefY$Defd, gefY_expected$Defd)
    expect_equal(gefY$Befd, gefY_expected$Befd)
})

gef <- calcGef(lat = 37.2,
               dataRad = list(G0dm = G0dm, Ta = Ta, year = 2023),
               modeTrk = 'two')
gefI <- as.data.tableI(gef)
gefD <- as.data.tableD(gef)
gefM <- as.data.tableM(gef)
gefY <- as.data.tableY(gef)
gefI_expected <- read.csv('files/gef2.csv', sep = ';')
gefD_expected <- read.csv('files/gef2.D.csv', sep = ';')
gefM_expected <- read.csv('files/gef2.M.csv', sep = ';')
gefY_expected <- read.csv('files/gef2.Y.csv', sep = ';')

test_that('calcGef in two axis tracker', {
    expect_equal(gefI$Gef, gefI_expected$Gef)
    expect_equal(gefI$Bef, gefI_expected$Bef)
    expect_equal(gefI$Def, gefI_expected$Def)
    expect_equal(gefD$Gefd, gefD_expected$Gefd)
    expect_equal(gefD$Defd, gefD_expected$Defd)
    expect_equal(gefD$Befd, gefD_expected$Befd)
    expect_equal(gefM$Bod, gefM_expected$Bod)
    expect_equal(gefM$Bnd, gefM_expected$Bnd)
    expect_equal(gefM$Gd, gefM_expected$Gd)
    expect_equal(gefM$Dd, gefM_expected$Dd)
    expect_equal(gefM$Bd, gefM_expected$Bd)
    expect_equal(gefM$Gefd, gefM_expected$Gefd)
    expect_equal(gefM$Defd, gefM_expected$Defd)
    expect_equal(gefM$Befd, gefM_expected$Befd)
    expect_equal(gefY$Bod, gefY_expected$Bod)
    expect_equal(gefY$Bnd, gefY_expected$Bnd)
    expect_equal(gefY$Gd, gefY_expected$Gd)
    expect_equal(gefY$Dd, gefY_expected$Dd)
    expect_equal(gefY$Bd, gefY_expected$Bd)
    expect_equal(gefY$Gefd, gefY_expected$Gefd)
    expect_equal(gefY$Defd, gefY_expected$Defd)
    expect_equal(gefY$Befd, gefY_expected$Befd)
})

struct = list(W = 23.11, L = 9.8, Nrow = 2, Ncol = 8)
distances = data.table(Lew = 40, Lns = 30, H = 0)
gef <- calcGef(lat = 37.2, modeTrk = 'two',
               dataRad = list(G0dm = G0dm, Ta = Ta, year = 2023),
               modeShd = c('area', 'prom'),
               struct = struct, distances = distances)
gefI <- as.data.tableI(gef)
gefD <- as.data.tableD(gef)
gefM <- as.data.tableM(gef)
gefY <- as.data.tableY(gef)
gefI_expected <- read.csv('files/gefShd.csv', sep = ';')
gefD_expected <- read.csv('files/gefShd.D.csv', sep = ';')
gefM_expected <- read.csv('files/gefShd.M.csv', sep = ';')
gefY_expected <- read.csv('files/gefShd.Y.csv', sep = ';')

test_that('calcGef in two axis tracker', {
    expect_equal(gefI$Gef, gefI_expected$Gef)
    expect_equal(gefI$Bef, gefI_expected$Bef)
    expect_equal(gefI$Def, gefI_expected$Def)
    expect_equal(gefD$Gefd, gefD_expected$Gefd)
    expect_equal(gefD$Defd, gefD_expected$Defd)
    expect_equal(gefD$Befd, gefD_expected$Befd)
    expect_equal(gefM$Bod, gefM_expected$Bod)
    expect_equal(gefM$Bnd, gefM_expected$Bnd)
    expect_equal(gefM$Gd, gefM_expected$Gd)
    expect_equal(gefM$Dd, gefM_expected$Dd)
    expect_equal(gefM$Bd, gefM_expected$Bd)
    expect_equal(gefM$Gefd, gefM_expected$Gefd)
    expect_equal(gefM$Defd, gefM_expected$Defd)
    expect_equal(gefM$Befd, gefM_expected$Befd)
    expect_equal(gefY$Bod, gefY_expected$Bod)
    expect_equal(gefY$Bnd, gefY_expected$Bnd)
    expect_equal(gefY$Gd, gefY_expected$Gd)
    expect_equal(gefY$Dd, gefY_expected$Dd)
    expect_equal(gefY$Bd, gefY_expected$Bd)
    expect_equal(gefY$Gefd, gefY_expected$Gefd)
    expect_equal(gefY$Defd, gefY_expected$Defd)
    expect_equal(gefY$Befd, gefY_expected$Befd)
})
