% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminal_nodes.R
\name{terminalNodesDepthPerTree}
\alias{terminalNodesDepthPerTree}
\title{Depth of each terminal node of a single tree in a ranger model}
\usage{
terminalNodesDepthPerTree(treelike)
}
\arguments{
\item{treelike}{Output of `ranger::treeInfo`}
}
\value{
Named vector of depths where the names are the terminal node IDs
}
\description{
Depth of each terminal node of a single tree in a ranger model.
  Note that root node has the node_id = 0.
}
\examples{
\dontrun{
  rf = ranger::ranger(Species ~ ., data = iris)
  terminalNodesDepthPerTree(ranger::treeInfo(rf, 1))
}
}
