% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.continue.R
\name{som.nn.continue}
\alias{som.nn.continue}
\title{Continue hexagonal som training}
\usage{
som.nn.continue(model, x, kernel = "internal", len = 0, alpha = 0.2,
  radius = 0)
}
\arguments{
\item{model}{model of type \code{SOMnn}.}

\item{x}{data.fame with training data. Samples are requested as rows and taken randomly for the
training steps. All
columns except of the class lables are considered to be attributes and parts of
the training vector.
\code{x} must include the same columns as the data.frame with which the model
have been trained originally.
One column is needed as class labels. The column with class
lables is selected by the slot \code{class.idx} of the model.}

\item{kernel}{Kernel for som training. One of the predefined kernels
\code{"internal"} == train with the R-implementation or 
\code{"SOM"} == train with \code{\link[class]{SOM}} or 
\code{"kohonen"} == train with \code{\link[kohonen]{som}} (\code{kohonen::som}) or 
\code{"som"} == train with \code{\link[som]{som}} (\code{som::som}). 
If a function is specified (as closure, not as character)
the specified custom function is used for training.}

\item{len}{number of steps to be trained (steps - not epochs!).}

\item{alpha}{initial training rate; default 0.02.}

\item{radius}{inital radius for SOM training.
If Gaussian distance function is used, radius corresponds to sigma.}
}
\value{
S4 object of type \code{\link{SOMnn}} with the trained model
}
\description{
An existing self-organising map with hexagonal tolology is further trained and
a model created for prediction of unknown samples.
In contrast to a "normal" som, class-labels for all samples of
the training set are required to build the model.
}
\details{
Any specified custom kernel function is used for som training. The function must match the 
signature \code{kernel(data, grid, rlen, alpha, radius, init, toroidal)}, with 
arguments:
\itemize{
  \item \code{data} \code{numeric} matrix of training data; one sample per row
  \item \code{classes:} optional \code{charater} vector of classes for training data
  \item \code{grid} somgrid, generated with \code{\link[class]{somgrid}}
  \item \code{rlen} number of training steps
  \item \code{alpha} training rate
  \item \code{radius} training radius
  \item \code{init} \code{numeric} matrix of initial codebook vectors; one code per row
  \item \code{toroidal} \code{logical}; TRUE, if the topology of grid is toroidal
}
The returned value must be a list with at minimum one element 
\itemize{
  \item \code{codes:} \code{numeric} matrix of result codebook vectors; one code per row
}
}
\examples{
## get example data and add class labels:
data(iris)
species <- iris$Species

## train with default radius = diagonal / 2:
som <- som.nn.train(iris, class.col = "Species", kernel = "internal",
                    xdim = 15, ydim = 9, alpha = 0.2, len = 10000, 
                    norm = TRUE, toroidal = FALSE)


## continue training with different alpha and radius;
som <- som.nn.continue(som, iris, alpha = 0.02, len=1000, radius = 5)
som <- som.nn.continue(som, iris, alpha = 0.02, len=1000, radius = 2)

## predict some samples:
unk <- iris[,!(names(iris) \%in\% "Species")]

setosa <- unk[species=="setosa",]
setosa <- setosa[sample(nrow(setosa), 20),]

versicolor <- unk[species=="versicolor",]
versicolor <- versicolor[sample(nrow(versicolor), 20),]

virginica <- unk[species=="virginica",]
virginica <- virginica[sample(nrow(virginica), 20),]

p <- predict(som, unk)
head(p)

## plot:
plot(som)
dev.off()
plot(som, predict = som@predict(setosa))
plot(som, predict = som@predict(versicolor), add = TRUE, pch.col = "magenta", pch = 17)
plot(som, predict = som@predict(virginica), add = TRUE, pch.col = "white", pch = 8)

}

