\name{cornHybrid}
\alias{cornHybrid}
\docType{data}
\title{
Corn crosses and markers
}
\description{
This dataset contains phenotpic data for plant height and grain yield for 100 out of 400 possible hybrids originated from 40 inbred lines belonging to 2 heterotic groups, 20 lines in each, 1600 rows exist for the 400 possible hybrids evaluated in 4 locations but only 100 crosses have phenotypic information.  The purpose of this data is to show how to predict the other 300 crosses.

The data contains 3 elements. The first is the phenotypic data and the parent information for each cross evaluated in the 4 locations. 1200 rows should have missing data but the 100 crosses performed were chosen to be able to estimate the GCA and SCA effects of everything.

The second element of the data set is the phenotypic data and other relevant information for the 40.

The third element is the genomic relationship matrix for the 40 inbred lines originated from 511 SNP markers and calculated using the A.mat function from the rrBLUP package.

}
\usage{data("cornHybrid")}
\format{
  The format is:
 chr "cornHybrid"
}
\source{
This data was generated by a corn study.
}
\references{
Covarrubias-Pazaran G (2016) sommer: An R package for mixed model analysis education. R package version 1.1. URL https://cran.r-project.org/web/packages/sommer/.
}
\examples{
data(cornHybrid)
## look at the list structure
str(cornHybrid) 
############################################
############################################
# breeding values with 3 variance components
# hybrid prediction
############################################
############################################
#data(cornHybrid)
#hybrid2 <- cornHybrid$hybrid # extract cross data
#A <- cornHybrid$K
#y <- hybrid2$Yield
#X1 <- model.matrix(~ Location, data = hybrid2);dim(X1)
#Z1 <- model.matrix(~ GCA1 -1, data = hybrid2);dim(Z1)
#Z2 <- model.matrix(~ GCA2 -1, data = hybrid2);dim(Z2)
#Z3 <- model.matrix(~ SCA -1, data = hybrid2);dim(Z3)

#K1 <- A[levels(hybrid2$GCA1), levels(hybrid2$GCA1)]; dim(K1)     
### Realized IBS relationships for set of parents 1
#K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)     
### Realized IBS relationships for set of parents 2
#S <- kronecker(K1, K2) ; dim(S)   
#rownames(S) <- colnames(S) <- levels(hybrid2$SCA)
### Realized IBS relationships for cross 
###(as the Kronecker product of K1 and K2)

#ETA <- list(list(Z=Z1, K=K1), list(Z=Z2, K=K2), list(Z=Z3, K=S))
### run the next line, ommited for CRAN time limitations
#ans <- mmer(y=y, X=X1, Z=ETA)
#ans$var.comp
#summary(ans)
}
\keyword{datasets}
