% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dayPhase.R
\name{dayPhase}
\alias{dayPhase}
\title{Phase of day}
\usage{
dayPhase(
  time = Sys.time(),
  duration = 2e+05,
  lat = 50.1,
  lon = 1.83,
  tz = "UTC"
)
}
\arguments{
\item{time}{A time object representing the start time of a recording}

\item{duration}{Duration of recording}

\item{lat}{Latitude of recording device}

\item{lon}{Longitude of recording device}

\item{tz}{Time-zone of recording device when recording was made}
}
\value{
Data frame of day phases with absolute timestamps and relative times within file
}
\description{
Given a start time and (optionally) a duration returns the phase of day at a given
location. This is primarily used to calculate phase of day information for soundscape
recording projects.
}
\examples{
dayPhase <- function(time=Sys.time(), duration=200000, lat=50.1, lon=1.83, tz="UTC")

}
