% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_parameter_space.R
\name{rotate_parameter_space}
\alias{rotate_parameter_space}
\title{Rotate the parameter space of a SOO function.}
\usage{
rotate_parameter_space(fn)
}
\arguments{
\item{fn}{A \code{soo_function} object.}
}
\value{
A new \code{soo_function} object where the parameter space
 has been randomly rotated.
}
\description{
This function is a simple parameter space transformation. Given a
function \eqn{f(x)} it retuns a new function \eqn{f_r(x) = f(Rx)},
where \eqn{R} is a random rotation matrix.
}
\details{
If you want repeatable results, make sure you explicitly set a
seed before calling \code{rotate_parameter_space}.
}
\examples{
f <- generate_ackley_function(2)
f_r <- rotate_parameter_space(f)
par(mfrow=c(1, 2))
plot(f)
plot(f_r)

}
