% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{generateNoise}
\alias{generateNoise}
\title{Generate noise}
\usage{
generateNoise(len, noiseAnchors = data.frame(time = c(0, 300), value = c(-120,
  -120)), rolloffNoise = -4, attackLen = 10, flatSpectrum = 1200,
  windowLength_points = 1024, samplingRate = 16000, overlap = 75,
  throwaway = -120, filterNoise = NA)
}
\arguments{
\item{len}{length of output}

\item{noiseAnchors}{a dataframe specifying the amplitude envelope of
output. $time: timing of aspiration noise, ms c(start,finish) relative to
voiced part, eg c(-100,500) means breathing starts 100 ms before the voiced
part and lasts until 500 ms into the voiced part (eg total duration of
breathing = 500 - (-100) = 600 ms). noiseAnchors$value: the amount of
aspiration noise at the given time anchors (to be smoothed). throwaway =
no breathing, 0 = as strong as the voiced (harmonic) part}

\item{rolloffNoise}{rolloff of noise, dB/octave. It is analogous to
\code{rolloff}, but while \code{rolloff} applies to the harmonic component,
\code{rolloffNoise} applies to the noise component}

\item{attackLen}{duration of fade-in / fade-out at each end of syllables and
noise (ms)}

\item{flatSpectrum}{keep spectrum flat up to ... Hz (ie rolloffNoise applies
only above this frequency)}

\item{windowLength_points}{the length of fft window, points}

\item{samplingRate}{sampling frequency, Hz}

\item{overlap}{FFT window overlap, \%}

\item{throwaway}{discard harmonics and noise that are quieter than this
number (in dB, defaults to -120) to save computational resources}

\item{filterNoise}{(optional): in addition to using rolloffNoise,
we can provide the exact filter - a vector of length windowLength_points/2
or, if we want moving formants, a matrix with windowLength_points/2 rows
and an arbitrary number of columns}
}
\description{
Internal soundgen function.
}
\details{
Generates white noise of length \code{len} and with spectrum defined by
linear decay \code{rolloffNoise} above \code{flatSpectrum} and/or a specified
filter \code{filterNoise}. Algorithm: paints a spectrum with desired
characteristics, sets phase to zero, and generates a time sequence via
inverse FFT. Noise can then be used as an additional source to be added to
the glottal source AFTER the glottal source has been formant-filtered, or
BEFORE formant-filtering for glottal breathing noise.
}
\examples{
# 1 s of white noise
samplingRate = 16000
noise = soundgen:::generateNoise(len = samplingRate,
  rolloffNoise = 0, samplingRate = samplingRate)
# playme(noise, samplingRate = samplingRate)
# 1 s of noise with rolloff -6 dB
noise = soundgen:::generateNoise(len = samplingRate,
  rolloffNoise = -6, samplingRate = samplingRate)

# To create a sibilant [s], specify a single strong, broad formant at ~7 kHz:
windowLength_points = 1024
filterNoise = soundgen:::getSpectralEnvelope(
  nr = windowLength_points / 2, nc = 1, samplingRate = samplingRate,
 formants = list('f1' = data.frame(time = 0, freq = 7000,
                                   amp = 50, width = 2000)))
noise = soundgen:::generateNoise(len = samplingRate, rolloffNoise = -4,
  samplingRate = samplingRate, filterNoise = filterNoise)
# plot(filterNoise, type = 'l')
# playme(noise, samplingRate = samplingRate)

# low-frequency, wind-like noise
filterNoise = soundgen:::getSpectralEnvelope(
  nr = windowLength_points / 2, nc = 1, lipRad = 0,
  samplingRate = samplingRate, formants = list('f1' = data.frame(
    time = 0, freq = 150, amp = 30, width = 90)))
noise = soundgen:::generateNoise(len = samplingRate, rolloffNoise = -12,
  samplingRate = samplingRate, filterNoise = filterNoise)
# playme(noise, samplingRate = samplingRate)
}
\keyword{internal}
