% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osc.R
\name{.osc}
\alias{.osc}
\title{Oscillogram per sound}
\usage{
.osc(
  audio,
  dynamicRange = 80,
  dB = FALSE,
  returnWave = FALSE,
  plot = TRUE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  bty = "n",
  midline = TRUE,
  maxPoints = 10000,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{dB}{if TRUE, plots on a dB instead of linear scale}

\item{returnWave}{if TRUE, returns a log-transformed waveform as a numeric vector}

\item{plot}{if TRUE, plots the oscillogram}

\item{main}{plot title}

\item{xlab, ylab}{axis labels}

\item{ylim}{override default amplitude scale for non-centered sounds}

\item{bty}{box type (see `?par`)}

\item{midline}{if TRUE, draws a line at 0 dB}

\item{maxPoints}{the maximum number of points to plot (speeds up the plotting
of long audio files, but beware of antialiasing)}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{Other graphical parameters passed on to `plot()`}
}
\description{
Internal soundgen function called by \code{\link{osc}}.
}
\keyword{internal}
