% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants_utilities.R
\name{getFormants}
\alias{getFormants}
\title{Get formants}
\usage{
getFormants(
  audio,
  windowLength = 50,
  step = 25,
  wn = "gaussian",
  zp = 0,
  dynamicRange = 80,
  silence = 0.04,
  formants = list(),
  nFormants = NULL
)
}
\arguments{
\item{audio}{input sound as returned by readAudio}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{silence}{(0 to 1 as proportion of max amplitude) frames with RMS
amplitude below \code{silence * max_ampl adjusted by scale} are not
analyzed at all.}

\item{formants}{a list of arguments passed to
\code{\link[phonTools]{findformants}} - an external function called to
perform LPC analysis}

\item{nFormants}{the number of formants to extract per STFT frame (0 = no
formant analysis, NULL = as many as possible)}
}
\description{
Internal soundgen function
}
\details{
A barebones version of analyze() that only measures formants. Called by
formant_app()
}
\examples{
data(sheep, package = 'seewave')
f = soundgen:::getFormants(soundgen:::readAudio(sheep, from = .1, to = .5))
f[11:15, 1:5]
}
\keyword{internal}
