% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nkde_execution_functions_sf.R
\name{nkde.mc}
\alias{nkde.mc}
\title{Network Kernel density estimate (multicore)}
\usage{
nkde.mc(
  lines,
  events,
  w,
  samples,
  kernel_name,
  bw,
  adaptive = FALSE,
  trim_bw = NULL,
  method,
  div = "bw",
  diggle_correction = FALSE,
  study_area = NULL,
  max_depth = 15,
  digits = 5,
  tol = 0.1,
  agg = NULL,
  sparse = TRUE,
  grid_shape = c(1, 1),
  verbose = TRUE,
  check = TRUE
)
}
\arguments{
\item{lines}{A feature collection of linestrings representing the underlying network. The
geometries must be simple Linestrings (may crash if some geometries
are invalid) without MultiLineSring.}

\item{events}{events A feature collection of points representing the events on the
network. The points will be snapped on the network to their closest line.}

\item{w}{A vector representing the weight of each event}

\item{samples}{A feature collection of points representing the locations for
which the densities will be estimated.}

\item{kernel_name}{The name of the kernel to use. Must be one of triangle,
gaussian, tricube, cosine, triweight, quartic, epanechnikov or uniform.}

\item{bw}{The kernel bandwidth (using the scale of the lines), can be a
single float or a numeric vector if a different bandwidth must be used
for each event.}

\item{adaptive}{A Boolean, indicating if an adaptive bandwidth must be
used}

\item{trim_bw}{A float, indicating the maximum value for the adaptive
bandwidth}

\item{method}{The method to use when calculating the NKDE, must be one of
simple / discontinuous / continuous (see nkde details for more information)}

\item{div}{The divisor to use for the kernel. Must be "n" (the number of
events within the radius around each sampling point), "bw" (the bandwidth)
"none" (the simple sum).}

\item{diggle_correction}{A Boolean indicating if the correction factor
for edge effect must be used.}

\item{study_area}{A feature collection of polygons
representing the limits of the study area.}

\item{max_depth}{when using the continuous and discontinuous methods, the
calculation time and memory use can go wild  if the network has many
small edges (area with many of intersections and many events). To
avoid it, it is possible to set here a maximum depth. Considering that the
kernel is divided at intersections, a value of 10 should yield good
estimates in most cases. A larger value can be used without a problem for the
discontinuous method. For the continuous method, a larger value will
strongly impact calculation speed.}

\item{digits}{The number of digits to retain from the spatial coordinates. It
ensures that topology is good when building the network. Default is 3. Too high a
precision (high number of digits) might break some connections}

\item{tol}{A float indicating the minimum distance between the events and the
lines' extremities when adding the point to the network. When points are
closer, they are added at the extremity of the lines.}

\item{agg}{A double indicating if the events must be aggregated within a
distance. If NULL, the events are aggregated only by rounding the
coordinates.}

\item{sparse}{A Boolean indicating if sparse or regular matrices should be
used by the Rcpp functions. These matrices are used to store edge indices
between two nodes in a graph. Regular matrices are faster, but require more
memory, in particular with multiprocessing. Sparse matrices are slower (a
bit), but require much less memory.}

\item{grid_shape}{A vector of two values indicating how the study area
must be split when performing the calculus. Default is c(1,1) (no split). A finer grid could
reduce memory usage and increase speed when a large dataset is used. When using
multiprocessing, the work in each grid is dispatched between the workers.}

\item{verbose}{A Boolean, indicating if the function should print messages
about the process.}

\item{check}{A Boolean indicating if the geometry checks must be run before
the operation. This might take some times, but it will ensure that the CRS
of the provided objects are valid and identical, and that geometries are valid.}
}
\value{
A vector of values, they are the density estimates at sampling
points
}
\description{
Calculate the Network Kernel Density Estimate based on a network of lines,
sampling points, and events with multicore support.
}
\details{
For more details, see help(nkde)
}
\examples{
\donttest{
data(mtl_network)
data(bike_accidents)
future::plan(future::multisession(workers=1))
lixels <- lixelize_lines(mtl_network,200,mindist = 50)
samples <- lines_center(lixels)
densities <- nkde.mc(mtl_network,
                  events = bike_accidents,
                  w = rep(1,nrow(bike_accidents)),
                  samples = samples,
                  kernel_name = "quartic",
                  bw = 300, div= "bw",
                  adaptive = FALSE, agg = 15,
                  method = "discontinuous", digits = 1, tol = 1,
                  grid_shape = c(3,3),
                  verbose=TRUE)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
