% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varpro_3_para.R
\name{varpro_3_para_opts}
\alias{varpro_3_para_opts}
\title{Return a list of options for VARPRO based fitting with 3 free parameters.}
\usage{
varpro_3_para_opts(
  nstart = 20,
  init_damping = 2,
  maxiters = 200,
  max_shift = 5,
  max_damping = 5,
  anal_jac = FALSE,
  bl_smth_pts = 80
)
}
\arguments{
\item{nstart}{position in the time-domain to start fitting, units of data
points.}

\item{init_damping}{starting value for the global Gaussian line-broadening
term - measured in Hz.}

\item{maxiters}{maximum number of levmar iterations to perform.}

\item{max_shift}{maximum global shift allowed, measured in Hz.}

\item{max_damping}{maximum damping allowed, FWHM measured in Hz.}

\item{anal_jac}{option to use the analytic or numerical Jacobian (logical).}

\item{bl_smth_pts}{number of data points to use in the baseline smoothing
calculation.}
}
\value{
list of options.
}
\description{
Return a list of options for VARPRO based fitting with 3 free parameters.
}
