% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_alternating_least_squares.R
\name{ml_als_factorization}
\alias{ml_als_factorization}
\title{Spark ML -- Alternating Least Squares (ALS) matrix factorization.}
\usage{
ml_als_factorization(x, rating.column = "rating", user.column = "user",
  item.column = "item", rank = 10L, regularization.parameter = 0.1,
  iter.max = 10L, ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{rating.column}{The name of the column containing ratings.}

\item{user.column}{The name of the column containing user IDs.}

\item{item.column}{The name of the column containing item IDs.}

\item{rank}{Rank of the factorization.}

\item{regularization.parameter}{The regularization parameter.}

\item{iter.max}{The maximum number of iterations to use.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Perform alternating least squares matrix factorization on a Spark DataFrame.
}
\seealso{
Other Spark ML routines: \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_gradient_boosted_trees}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}

