% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_gradient_boosted_tree.R
\name{ml_gradient_boosted_trees}
\alias{ml_gradient_boosted_trees}
\title{Spark ML -- Gradient-Boosted Tree}
\usage{
ml_gradient_boosted_trees(x, response, features, max.bins = 32L,
  max.depth = 5L, type = c("auto", "regression", "classification"),
  ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{response}{The name of the response vector (as a length-one character
vector), or a formula, giving a symbolic description of the model to be
fitted. When \code{response} is a formula, it is used in preference to other
parameters to set the \code{response}, \code{features}, and \code{intercept}
parameters (if available). Currently, only simple linear combinations of
existing parameters is supposed; e.g. \code{response ~ feature1 + feature2 + ...}.
The intercept term can be omitted by using \code{- 1} in the model fit.}

\item{features}{The name of features (terms) to use for the model fit.}

\item{max.bins}{The maximum number of bins used for discretizing
continuous features and for choosing how to split on features at
each node. More bins give higher granularity.}

\item{max.depth}{Maximum depth of the tree (>= 0); that is, the maximum
number of nodes separating any leaves from the root of the tree.}

\item{type}{The type of model to fit. \code{"regression"} treats the response
as a continuous variable, while \code{"classification"} treats the response
as a categorical variable. When \code{"auto"} is used, the model type is
inferred based on the response variable type -- if it is a numeric type,
then regression is used; classification otherwise.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Perform regression or classification using gradient-boosted trees.
}
\seealso{
Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}

