% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_kmeans.R
\name{ml_kmeans}
\alias{ml_kmeans}
\title{Spark ML -- K-Means Clustering}
\usage{
ml_kmeans(x, centers, iter.max = 100, features = dplyr::tbl_vars(x),
  compute.cost = TRUE, tolerance = 1e-04, ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{centers}{The number of cluster centers to compute.}

\item{iter.max}{The maximum number of iterations to use.}

\item{features}{The name of features (terms) to use for the model fit.}

\item{compute.cost}{Whether to compute cost for \code{k-means} model using Spark's \href{https://github.com/apache/spark/blob/master/mllib/src/main/scala/org/apache/spark/mllib/clustering/KMeansModel.scala#L84}{computeCost}.}

\item{tolerance}{Param for the convergence tolerance for iterative algorithms.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments. The \code{data} argument can be used to
specify the data to be used when \code{x} is a formula; this allows calls
of the form \code{ml_linear_regression(y ~ x, data = tbl)}, and is
especially useful in conjunction with \code{\link{do}}.}
}
\value{
\link{ml_model} object of class \code{kmeans} with overloaded \code{print}, \code{fitted} and \code{predict} functions.
}
\description{
Perform k-means clustering on a Spark DataFrame.
}
\references{
Bahmani et al., Scalable K-Means++, VLDB 2012
}
\seealso{
For information on how Spark k-means clustering is implemented, please see
  \url{http://spark.apache.org/docs/latest/mllib-clustering.html#k-means}.

Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_gradient_boosted_trees}},
  \code{\link{ml_lda}}, \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}

