% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_context_config.R
\name{spark_auto_broadcast_join_threshold}
\alias{spark_auto_broadcast_join_threshold}
\title{Retrieves or sets the auto broadcast join threshold}
\usage{
spark_auto_broadcast_join_threshold(sc, threshold = NULL)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{threshold}{Maximum size in bytes for a table that will be broadcast to all worker nodes
when performing a join. Defaults to \code{NULL} to retrieve configuration entries.}
}
\description{
Configures the maximum size in bytes for a table that will be broadcast to all worker nodes
when performing a join. By setting this value to -1 broadcasting can be disabled. Note that
currently statistics are only supported for Hive Metastore tables where the command
`ANALYZE TABLE <tableName> COMPUTE STATISTICS noscan` has been run, and file-based data source
tables where the statistics are computed directly on the files of data.
}
\seealso{
Other Spark runtime configuration: 
\code{\link{spark_adaptive_query_execution}()},
\code{\link{spark_advisory_shuffle_partition_size}()},
\code{\link{spark_coalesce_initial_num_partitions}()},
\code{\link{spark_coalesce_min_num_partitions}()},
\code{\link{spark_coalesce_shuffle_partitions}()},
\code{\link{spark_session_config}()}
}
\concept{Spark runtime configuration}
