% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_feature_hasher.R
\name{ft_feature_hasher}
\alias{ft_feature_hasher}
\title{Feature Transformation -- FeatureHasher (Transformer)}
\usage{
ft_feature_hasher(
  x,
  input_cols = NULL,
  output_col = NULL,
  num_features = 2^18,
  categorical_cols = NULL,
  uid = random_string("feature_hasher_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{input_cols}{Names of input columns.}

\item{output_col}{Name of output column.}

\item{num_features}{Number of features. Defaults to \eqn{2^18}.}

\item{categorical_cols}{Numeric columns to treat as categorical features.
By default only string and boolean columns are treated as categorical,
so this param can be used to explicitly specify the numerical columns to
treat as categorical.}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}
}
\value{
The object returned depends on the class of \code{x}.

\itemize{
  \item \code{spark_connection}: When \code{x} is a \code{spark_connection}, the function returns a \code{ml_transformer},
  a \code{ml_estimator}, or one of their subclasses. The object contains a pointer to
  a Spark \code{Transformer} or \code{Estimator} object and can be used to compose
  \code{Pipeline} objects.

  \item \code{ml_pipeline}: When \code{x} is a \code{ml_pipeline}, the function returns a \code{ml_pipeline} with
  the transformer or estimator appended to the pipeline.

  \item \code{tbl_spark}: When \code{x} is a \code{tbl_spark}, a transformer is constructed then
  immediately applied to the input \code{tbl_spark}, returning a \code{tbl_spark}
}
}
\description{
Feature Transformation -- FeatureHasher (Transformer)
}
\details{
Feature hashing projects a set of categorical or numerical features into a
  feature vector of specified dimension (typically substantially smaller than
  that of the original feature space). This is done using the hashing trick
  \url{https://en.wikipedia.org/wiki/Feature_hashing} to map features to indices
  in the feature vector.

  The FeatureHasher transformer operates on multiple columns. Each column may
    contain either numeric or categorical features. Behavior and handling of
    column data types is as follows: -Numeric columns: For numeric features,
    the hash value of the column name is used to map the feature value to its
    index in the feature vector. By default, numeric features are not treated
    as categorical (even when they are integers). To treat them as categorical,
    specify the relevant columns in categoricalCols. -String columns: For
     categorical features, the hash value of the string "column_name=value"
     is used to map to the vector index, with an indicator value of 1.0.
     Thus, categorical features are "one-hot" encoded (similarly to using
     OneHotEncoder with drop_last=FALSE). -Boolean columns: Boolean values
     are treated in the same way as string columns. That is, boolean features
     are represented as "column_name=true" or "column_name=false", with an
     indicator value of 1.0.

 Null (missing) values are ignored (implicitly zero in the resulting feature vector).

 The hash function used here is also the MurmurHash 3 used in HashingTF. Since a
 simple modulo on the hashed value is used to determine the vector index, it is
 advisable to use a power of two as the num_features parameter; otherwise the
 features will not be mapped evenly to the vector indices.
}
\seealso{
See \url{http://spark.apache.org/docs/latest/ml-features.html} for
  more information on the set of transformations available for DataFrame
  columns in Spark.

Other feature transformers: 
\code{\link{ft_binarizer}()},
\code{\link{ft_bucketizer}()},
\code{\link{ft_chisq_selector}()},
\code{\link{ft_count_vectorizer}()},
\code{\link{ft_dct}()},
\code{\link{ft_elementwise_product}()},
\code{\link{ft_hashing_tf}()},
\code{\link{ft_idf}()},
\code{\link{ft_imputer}()},
\code{\link{ft_index_to_string}()},
\code{\link{ft_interaction}()},
\code{\link{ft_lsh}},
\code{\link{ft_max_abs_scaler}()},
\code{\link{ft_min_max_scaler}()},
\code{\link{ft_ngram}()},
\code{\link{ft_normalizer}()},
\code{\link{ft_one_hot_encoder_estimator}()},
\code{\link{ft_one_hot_encoder}()},
\code{\link{ft_pca}()},
\code{\link{ft_polynomial_expansion}()},
\code{\link{ft_quantile_discretizer}()},
\code{\link{ft_r_formula}()},
\code{\link{ft_regex_tokenizer}()},
\code{\link{ft_robust_scaler}()},
\code{\link{ft_sql_transformer}()},
\code{\link{ft_standard_scaler}()},
\code{\link{ft_stop_words_remover}()},
\code{\link{ft_string_indexer}()},
\code{\link{ft_tokenizer}()},
\code{\link{ft_vector_assembler}()},
\code{\link{ft_vector_indexer}()},
\code{\link{ft_vector_slicer}()},
\code{\link{ft_word2vec}()}
}
\concept{feature transformers}
