% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_operations.R
\name{stream_find}
\alias{stream_find}
\title{Find Stream}
\usage{
stream_find(sc, id)
}
\arguments{
\item{sc}{The associated Spark connection.}

\item{id}{The stream identifier to find.}
}
\description{
Finds and returns a stream based on the stream's identifier.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
sdf_len(sc, 10) \%>\%
  spark_write_parquet(path = "parquet-in")

stream <- stream_read_parquet(sc, "parquet-in") \%>\%
  stream_write_parquet("parquet-out")

stream_id <- stream_id(stream)
stream_find(sc, stream_id)
}

}
