% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval_correct.R
\name{pval_correct}
\alias{pval_correct}
\title{Calculate p-value corrections}
\usage{
pval_correct(
  input,
  type = c("FDR", "Sidak", "Bonferroni"),
  alpha = 0.05,
  nbc = NULL
)
}
\arguments{
\item{input}{An object of class 'rrs' from the \code{\link{spatial_power}} or \code{\link{jitter_power}} function.}

\item{type}{Character string specifying which correction for multiple comparisons. Options include a False Discovery Rate \code{p_correct = "FDR"}, an independent Sidak correction \code{p_correct = "uncorrelated Sidak"}, and an independent Bonferroni correction \code{p_correct = "uncorrelated Bonferroni"}.}

\item{alpha}{Numeric. The alpha level for significance threshold (default in \code{\link{spatial_power}} and \code{\link{jitter_power}} functions is 0.05).}
}
\value{
An object of class 'numeric' with the corrected alpha level.
}
\description{
Internal function to calculate various p-value corrections for use within the \code{\link{spatial_power}} and \code{\link{jitter_power}} functions.
}
\details{
This function provides functionality for multiple testing correction in five ways:

\enumerate{
\item Computes a False Discovery Rate by Benjamini and Hochberg \doi{10.1111/j.2517-6161.1995.tb02031.x} (\code{p_correct = "FDR"}) by: 1) sorting the p-values (p_i) of each knot in ascending order (p_1 <= p_2 <= ... <= p_m), 2) starting from p_m find the first p_i for which p_i <= (i/m) * alpha.
\item Computes an independent Sidak correction \doi{10.2307/2283989} (\code{p_correct = "uncorrelated Sidak"}) by 1 - (1 - \code{alpha}) ^ (1 / total number of gridded knots across the estimated surface). The default in the \code{\link[sparr]{risk}} function is a resolution of 128 x 128 or n = 16,384 knots and a custom resolution can be specified using the \code{resolution} argument within the \code{\link[sparr]{risk}} function.
\item Computes an independent Bonferroni correction (\code{p_correct = "uncorrelated Bonferroni"}) by \code{alpha} / total number of gridded knots across the estimated surface. The default in the \code{\link[sparr]{risk}} function is a resolution of 128 x 128 or n = 16,384 knots and a custom resolution can be specified using the \code{resolution} argument within the \code{\link[sparr]{risk}} function.
}
}
\keyword{internal}
