% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebn-main.R
\name{estimate.covariance}
\alias{estimate.covariance}
\alias{estimate.covariance}
\alias{estimate.precision}
\title{Covariance estimation}
\usage{
estimate.covariance(data, ...)

estimate.precision(data, ...)
}
\arguments{
\item{data}{data as \code{\link{sparsebnData}} object.}

\item{...}{(optional) additional parameters to \code{\link[sparsebn]{estimate.dag}}}
}
\value{
Solution path as a plain \code{\link{list}}. Each component is a \code{\link[Matrix]{Matrix}}
corresponding to an estimate of the covariance or precision (inverse covariance) matrix for a
given value of lambda.
}
\description{
Methods for inferring (i) Covariance matrices and (ii) Precision matrices for continuous,
Gaussian data.
}
\details{
For Gaussian data, the precision matrix corresponds to an undirected graphical model for the
distribution. This undirected graph can be tied to the corresponding directed graphical model;
see Sections 2.1 and 2.2 (equation (6)) of Aragam and Zhou (2015) for more details.
}
\examples{

data(cytometryContinuous)
dat <- sparsebnData(cytometryContinuous$data, type = "c", ivn = cytometryContinuous$ivn)
estimate.covariance(dat) # estimate covariance
estimate.precision(dat)  # estimate precision

}
