% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebn-main.R
\name{estimate.dag}
\alias{estimate.dag}
\title{Estimate a DAG from data}
\usage{
estimate.dag(data, lambdas = NULL, lambdas.length = 20, error.tol = 1e-04,
  max.iters = NULL, edge.threshold = NULL, concavity = 2,
  weight.scale = 1, convLb = 0.01, upperbound = 100, adaptive = FALSE,
  verbose = FALSE)
}
\arguments{
\item{data}{Data as \code{\link[sparsebnUtils]{sparsebnData}}.}

\item{lambdas}{(optional) Numeric vector containing a grid of lambda values (i.e. regularization
parameters) to use in the solution path. If missing, a default grid of values will be
used based on a decreasing log-scale  (see also \link[sparsebnUtils]{generate.lambdas}).}

\item{lambdas.length}{Integer number of values to include in the solution path. If \code{lambdas}
has also been specified, this value will be ignored.}

\item{error.tol}{Error tolerance for the algorithm, used to test for convergence.}

\item{max.iters}{Maximum number of iterations for each internal sweep.}

\item{edge.threshold}{Threshold parameter used to terminate the algorithm whenever the number of edges in the
current estimate has \code{> edge.threshold} edges. NOTE: This is not the same as \code{alpha} in
\code{\link[ccdrAlgorithm]{ccdr.run}}.}

\item{concavity}{(CCDr only) Value of concavity parameter. If \code{gamma > 0}, then the MCP will be used
with \code{gamma} as the concavity parameter. If \code{gamma < 0}, then the L1 penalty
will be used and this value is otherwise ignored.}

\item{weight.scale}{(CD only) A postitive number to scale weight matrix.}

\item{convLb}{(CD only) Small positive number used in Hessian approximation.}

\item{upperbound}{(CD only) A large positive value used to truncate the adaptive weights. A -1 value indicates that there is no truncation.}

\item{adaptive}{(CD only) \code{TRUE / FALSE}, if \code{TRUE} the adaptive algorithm will be run.}

\item{verbose}{\code{TRUE / FALSE} whether or not to print out progress and summary reports.}
}
\value{
A \code{\link[sparsebnUtils]{sparsebnPath}} object.
}
\description{
Estimate the structure of a DAG (Bayesian network) from data. Works with any
combination of discrete / continuous and observational / experimental data.
}
\details{
For details on the underlying methods, see \code{\link[ccdrAlgorithm]{ccdr.run}}
and \code{\link[discretecdAlgorithm]{cd.run}}.
}
\examples{

# Estimate a DAG from the cytometry data
data(cytometryContinuous)
dat <- sparsebnData(cytometryContinuous$data, type = "c", ivn = cytometryContinuous$ivn)
estimate.dag(dat)

}
