% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{densify}
\alias{densify}
\title{Densify with explicit zeroes}
\usage{
densify(A, B)
}
\arguments{
\item{A}{object of class Matrix}

\item{B}{object of class Matrix}
}
\value{
object of class Matrix
}
\description{
This function takes two sparse matrices and returns the first matrix padded with explicit zeros so that it is at least dense (probably denser) than the second matrix. This function only works with matrices of class Matrix
#'
}
\examples{
require(Matrix)
Q1 <- sparseMatrix(i = c(1, 2, 2), j = c(1, 1, 2), x = c(0.1, 0.2, 1))
Q2 <- sparseMatrix(i = c(1, 1, 2, 2),j = c(1, 2, 1, 2), x = c(0.1, 0.3, 0.2, 1))
Q1dens <- densify(Q1, Q2)
Q1
Q1dens
}
