% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_sparta.R
\name{equiv}
\alias{equiv}
\alias{equiv.sparta}
\title{Equiv}
\usage{
equiv(x, y)

\method{equiv}{sparta}(x, y)
}
\arguments{
\item{x}{sparta object}

\item{y}{sparta object}
}
\value{
Logical. \code{TRUE} if \code{x} and \code{y} are equivalent
}
\description{
Determine if two sparta objects are equivalent
}
\examples{

x <- array(
  c(1,0,0,2,3,4,0,0),
  dim = c(2,2,2),
  dimnames = list(
    a = c("a1", "a2"),
    b = c("b1", "b2"),
    c = c("c1", "c2")
  )
)

y <- array(
  c(2,0,0,2,3,4,0,0),
  dim = c(2,2,2),
  dimnames = list(
    a = c("a1", "a2"),
    b = c("b1", "b2"),
    c = c("c1", "c2")
  )
)

sx <- as_sparta(x)
sy <- as_sparta(y)

equiv(sx, sy)
equiv(sx, sx)

}
