getMediansSubset <-
function(FILEPATH,NUMRUNSPERSAMPLE,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,MEASURES,RESULTFILENAME,ALTFILENAME,MEDIANSFILENAME)
{
	RESULTS<-NULL

	for(i in 1:NUMRUNSPERSAMPLE)
	{
		FILEADDRESS = paste(FILEPATH,toString(i),"/",RESULTFILENAME,sep="")
		#print(FILEADDRESS)
	
		if(file.exists(FILEADDRESS))
		{
			# import model result
			com <- paste("cut -d, -f",OUTPUTFILECOLSTART,"-",OUTPUTFILECOLEND," ",FILEADDRESS,sep="")
			MODELRESULT<-read.csv(pipe(com))

			if(nrow(MODELRESULT)>0)
			{
				MEDIANSFORALLMEASURES<-NULL
	
				# NOW GET THE MEDIANS FOR EACH MEASURE
				for(l in 1:length(MEASURES))
				{
					MEASUREMEDIAN <- median(MODELRESULT[MEASURES[l]][,1])
					MEDIANSFORALLMEASURES<-cbind(MEDIANSFORALLMEASURES,MEASUREMEDIAN)
				}
				RESULTS<-rbind(RESULTS,MEDIANSFORALLMEASURES)
			}
			else		
			{
				if(!is.null(ALTFILENAME))
				{
					# USE THE ALTERNATIVE ON THIS OCCASION
					# ASSUMES IN SAME FORMAT AS ORIGINAL
					FILEADDRESS = paste(FILEPATH,toString(i),"/",ALTFILENAME,sep="")
					# import model result
					com <- paste("cut -d, -f",OUTPUTFILECOLSTART,"-",OUTPUTFILECOLEND," ",FILEADDRESS,sep="")
					MODELRESULT<-read.csv(pipe(com))
					MEDIANSFORALLMEASURES<-NULL
		
					# NOW GET THE MEDIANS FOR EACH MEASURE
					for(l in 1:length(MEASURES))
					{
						MEASUREMEDIAN <- median(MODELRESULT[MEASURES[l]][,1])
						MEDIANSFORALLMEASURES<-cbind(MEDIANSFORALLMEASURES,MEASUREMEDIAN)
					}
					RESULTS<-rbind(RESULTS,MEDIANSFORALLMEASURES)
				}
			}
		}
	}
	# OUTPUT IF THE RESULTS ARE NOT BLANK
	if(length(RESULTS)>0)
	{
		colnames(RESULTS)<-MEASURES

		RESULTSFILE = paste(FILEPATH,"/",MEDIANSFILENAME,sep="")
		write.csv(RESULTS,RESULTSFILE,quote = FALSE,row.names=FALSE)
	}
}

