% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt.centroids.R
\name{wt.centroid}
\alias{wt.centroid}
\title{Weighted centroid}
\usage{
wt.centroid(x, p, sp = TRUE)
}
\arguments{
\item{x}{sp SpatialPointsDataFrame class object}

\item{p}{Weights column in x@data slot}

\item{sp}{Output sp SpatailPoints class object (TRUE | FALSE)}
}
\value{
A vector or an sp class SpatialPoints object of the weighted coordinate centroid
}
\description{
Creates centroid of [x,y] coordinates based on a weights field
}
\note{
THe weighted centroid is calculated as:
[Xw]=[X]*[p], [Yw]=[Y]*[p], [sXw]=SUM[Xw], [sYw]=SUM[Yw], [sP]=SUM[p]
   wX=[sXw]/[sP], wY=[sYw]/[sP]    
   where; X=X COORDINATE(S), Y=Y COORDINATE(S), p=WEIGHT

Depends: sp
}
\examples{
require(sp)
 data(meuse)
 coordinates(meuse) = ~x+y
 wt.copper <- wt.centroid(meuse, 'copper', sp=TRUE) 
   wt.zinc <- wt.centroid(meuse, 'zinc', sp=TRUE) 
     plot(meuse, pch=20, cex=0.75, main='Weighted centroid(s)')
       points(wt.copper, pch=19, col='red', cex=1.5)  
         points(wt.zinc, pch=19, col='blue', cex=1.5)
        box() 
legend('topleft', legend=c('all','copper', 'zinc'), 
       pch=c(20,19,19),col=c('black','red','blue'))

}

