% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal.k.R
\name{optimal.k}
\alias{optimal.k}
\title{optimalK}
\usage{
optimal.k(x, nk = 10, plot = TRUE, cluster = TRUE, clara = FALSE, ...)
}
\arguments{
\item{x}{Numeric dataframe, matrix or vector}

\item{nk}{Number of clusters to test (2:nk)}

\item{plot}{Plot cluster silhouettes(TRUE/FALSE)}

\item{cluster}{Create cluster object with optimal k}

\item{clara}{Use clara model for large data}

\item{...}{Additional arguments passed to clara}
}
\description{
Find optimal k of k-Medoid partitions using silhouette widths
}
\note{
Depends: cluster
}
\examples{
require(cluster)
  x <- rbind(cbind(rnorm(10,0,0.5), rnorm(10,0,0.5)),
             cbind(rnorm(15,5,0.5), rnorm(15,5,0.5)))

  clust <- optimal.k(x, 20, plot=TRUE, cluster=TRUE)
    plot(silhouette(clust), col = c('red', 'green'))
      plot(clust, which.plots=1, main='K-Medoid fit')

# Extract multivariate and univariate mediods (class centres)
  clust$medoids
    pam(x[,1], 1)$medoids  

# join clusters to data
  x <- data.frame(x, k=clust$clustering) 

}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}
\references{
Theodoridis, S. & K. Koutroumbas(2006) Pattern Recognition 3rd ed.
}

