% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daymet.tiles.R
\name{daymet.tiles}
\alias{daymet.tiles}
\title{DAYMET Tile ID's}
\usage{
daymet.tiles(x, tiles, ids, coords, sp = FALSE)
}
\arguments{
\item{x}{A sp, raster or extent object (with same projection as tiles)}

\item{tiles}{A SpatialPolygonsDataFrame tile index (see notes)}

\item{ids}{A tile id field in the tiles index}

\item{coords}{A vector of xmin, xmax, ymin, ymax coordinates, in same 
projection as tiles}

\item{sp}{(TRUE/FALSE) Should an sp class SpatialPolygonsDataFrame 
object of associate tiles be returned}
}
\value{
Vector of DAYMET tile IDS or if sp = TRUE a sp class SpatialPolygonsDataFrame
}
\description{
Returns a vector of DAYMET tile id's within a specified extent
}
\note{
Function accepts sp, raster or extent class object or bounding coordinates. 
All input must be in the same projection as the tile index SpatialPolygonsDataFrame. 
The library includes the DAYMAT tile index "DAYMET_tiles" which can be add using 
data(), see examples.
}
\examples{
library(sp)
library(raster)
data(DAYMET_tiles)
e <- extent(-117.2567, -104.7523, 36.62797, 47.68194) 
  plot(DAYMET_tiles)
    plot(e, col="red", add=TRUE)

# Using extent object	
daymet.tiles(x = e, tiles = DAYMET_tiles, ids = "Id")

# Using sp object
e <- as(e, "SpatialPolygons")	
daymet.tiles(e, tiles = DAYMET_tiles, ids = "Id")

# Using bounding coordinates	
daymet.tiles(coords=c(-117.2567, -104.7523, 36.62797, 47.68194),
             tiles = DAYMET_tiles, ids = "Id" )

# Return sp polygons object
tiles <- daymet.tiles(x = e, tiles = DAYMET_tiles, ids = "Id", sp = TRUE)
  plot(DAYMET_tiles)
    plot(tiles, col="red", add=TRUE)
			 
\dontrun{
# batch download of DAYMET tiles using function
  tile.ids = daymet.tiles(e)
  download.daymet(years=2010, tile=tile.ids, data.type=c('tmin'))
 }

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
