% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri.R
\name{tri}
\alias{tri}
\title{Terrain Ruggedness Index}
\usage{
tri(r, s = 3, exact = TRUE, ...)
}
\arguments{
\item{r}{A terra SpatRaster class object}

\item{s}{Scale of window. Must be odd number, can represent 2
dimensions (eg., s=c(3,5) would represent a 3 x 5 window)}

\item{exact}{Calculate (TRUE/FALSE) the exact TRI or an algebraic
approximation.}

\item{...}{Additional arguments passed to terra::focal or terra::app}
}
\value{
A terra SpatRaster class object of the TRI
}
\description{
Implementation of the Riley et al (1999) Terrain Ruggedness Index
}
\details{
The algebraic approximation is considerably faster. However, because
inclusion of the center cell, the larger the scale the larger the divergence
of the minimum value. Resuls are driven by local variations so, fixed thresholds
are not very reliable. However there are some reccomended breaks (eg., Riley et al., 1999).

Riley et al., (1999) ranges for classifying Topographic Ruggedness Index:
\itemize{
\item 0-80 - level terrain surface.
\item 81-116 - nearly level surface.
\item 117-161 - slightly rugged surface.
\item 162-239 - intermediately rugged surface.
\item 240-497 - moderately rugged surface.
\item 498-958 - highly rugged surface.
\item gt 959 - extremely rugged surface.
}
}
\examples{
\donttest{
library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
  ( tri.ext <- tri(elev) )
  ( tri.app <- tri(elev, exact = FALSE) )
  plot(c(tri.ext, tri.app))
}

}
\references{
Riley, S.J., S.D. DeGloria and R. Elliot (1999) A terrain
ruggedness index that quantifies topographic heterogeneity,
Intermountain Journal of Sciences 5(1-4):23-27.
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
