% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_moran.R
\name{print_moran}
\alias{print_moran}
\title{Prints results of a Moran's I test}
\usage{
print_moran(
  model,
  caption = NULL,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}

\item{caption}{Character, caption of the output table, Default: \code{NULL}}

\item{verbose}{Logical, if \code{TRUE}, the resulting table is printed into the console, Default: \code{TRUE}}
}
\value{
Prints a table in the console using the \link[huxtable]{huxtable} package.
}
\description{
Prints the results of a Moran's I test on the residuals of a model.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)
 data(distance.matrix)

 #fitting random forest model
 rf.model <- rf(
   data = plant_richness_df,
   dependent.variable.name = "richness_species_vascular",
   predictor.variable.names = colnames(plant_richness_df)[5:21],
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 1000, 2000),
   n.cores = 1,
   verbose = FALSE
 )

 #printing Moran's I of model's residuals
 print_moran(rf.model)

}
}
\seealso{
\code{\link[=moran]{moran()}}, \code{\link[=moran_multithreshold]{moran_multithreshold()}}, \code{\link[=get_moran]{get_moran()}}, \code{\link[=plot_moran]{plot_moran()}}
}
