% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPanel.R
\name{getPanel}
\alias{getPanel}
\title{Extract all points with a specified panel id from a sample.}
\usage{
getPanel(shapefile, panelid)
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) containing a sample that
contains a feature column named panel_id.}

\item{panelid}{The overlapped panel in the shapefile shp the user wants
sample points from.}
}
\value{
The sample for the specified panel.
}
\description{
This is the main function for selecting sites using the BAS master
sample. It assumes that you have already defined the master sample using the
BoundingBox() function or will be selecting a marine master sample site in BC.
}
\examples{
# Halton frame overlapping panel design showing use of getPanel.

# Use the North Carolina shapefile supplied in the sf R package.
shp_file <- sf::st_read(system.file("shape/nc.shp", package="sf"))
shp_gates <- shp_file[shp_file$NAME == "Gates",]

# Vertically aligned master sample bounding box.
bb <- spbal::BoundingBox(shapefile = shp_gates)

# Three panels, of 20 samples each.
panels <- c(20, 20, 20)

# second panel overlaps first panel by 5, and third panel
# overlaps second panel by 5.
panel_overlap <- c(0, 5, 5)

# generate the sample.
samp <- spbal::HaltonFrame(J = c(4, 3),
                           boundingbox = bb,
                           panels = panels,
                           panel_overlap = panel_overlap,
                           shapefile = shp_gates)

# get halton frame data from our sample.
samp3 <- samp$hf.pts.shp
samp3

panelid <- 1
olPanel_1 <- spbal::getPanel(samp3, panelid)

}
\author{
Phil Davies.
}
