% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAS.R
\name{setBASIndex}
\alias{setBASIndex}
\title{Finds a set of Halton indices that will create BAS points within a shape bounding box.}
\usage{
setBASIndex(shapefile, bb, seeds = base::c(0, 0))
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) to select sites for.}

\item{bb}{Bounding box which defines the area around the study area. A bounding box must be
supplied.}

\item{seeds}{A vector of 2 seeds, u1 and u2. seeds must have a value when this function is called.}
}
\value{
A list containing two variables, \code{$boxes} containing indices of the BAS sample that fall
into the bounding box, \code{$J}, the number of subdivision powers taken to find those boxes, \code{$B},
the number of boxes that the indices relate to \code{(1-B)}, \code{$xlim}, the ylimit of the
bounding box of the shapefile, shifted to the \code{base[1]^J[1]} coordinates on the unit box
\code{[0,1)}, \code{$ylim}, the ylimit of the bounding box of the shapefile, shifted to the
\code{base[2]^J[2]} coordinates on the unit box \code{[0,1)}.
}
\description{
This function is designed to be called internally for efficiency in site selection.
}
\details{
To be used when doing a Master Sample and the bounding box of the greater frame is potentially much
larger than the the polygon being sampled. In this case, we don't want to generate points across the
entire larger bounding box region and then clip them. Instead, we can make use of the Halton sequence
and only generate BAS points near to the shape being sampled. This function finds returns those indices.
}
\keyword{internal}
