% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{generate_design}
\alias{generate_design}
\title{Generate an efficient experimental design}
\usage{
generate_design(
  utility,
  rows,
  model = "mnl",
  efficiency_criteria = c("a-error", "c-error", "d-error", "s-error"),
  algorithm = c("federov", "rsc", "random"),
  draws = c("pseudo-random", "mlhs", "standard-halton", "scrambled-halton",
    "standard-sobol", "scrambled-sobol"),
  R = 100,
  dudx = NULL,
  candidate_set = NULL,
  exclusions = NULL,
  control = list(cores = 1, max_iter = 10000, max_relabel = 10000, efficiency_threshold =
    0.1, sample_with_replacement = FALSE)
)
}
\arguments{
\item{utility}{A named list of utility functions. See the examples and the
vignette for examples of how to define these correctly for different types
of experimental designs.}

\item{rows}{An integer giving the number of rows in the final design}

\item{model}{A character string indicating the model to optimize the design
for. Currently the only model programmed is the 'mnl' model and this is also
set as the default.}

\item{efficiency_criteria}{A character string giving the efficiency criteria
to optimize for. One of 'a-error', 'c-error', 'd-error' or 's-error'. No
default is set and argument must be specified. Optimizing for multiple
criteria is not yet implemented and will result in an error.}

\item{algorithm}{A character string giving the optimization algorithm to use.
No default is set and the argument must be specified to be one of 'rsc',
'federov' or 'random'.}

\item{draws}{The type of draws to use with Bayesian priors. No default is set
 and must be specified even if you are not creating a Bayesian design. Can be
one of "pseudo-random", "mlhs", "standard-halton", "scrambled-halton",
"standard-sobol","scrambled-sobol".}

\item{R}{An integer giving the number of draws to use. The default is 100.}

\item{dudx}{A character string giving the name of the parameter in the
denominator. Must be specified when optimizing for 'c-error'}

\item{candidate_set}{A matrix or data frame in the "wide" format containing
all permitted combinations of attributes. The default is NULL. If no
candidate set is provided, then the full factorial subject to specified
exclusions will be used.}

\item{exclusions}{A list of exclusions Often this list will be pulled
directly from the list of options or it is a modified list of exclusions}

\item{control}{A list of control options}
}
\value{
An object of class 'spdesign'
}
\description{
The function generates efficient experimental designs. The function takes
a set of indirect utility functions and generates efficient experimental
designs assuming that people are maximizing utility.
}
\details{
No assumptions are made with respect to default values and it is up to the
user to specify optimization criteria, optmization routines, draws to use for
Bayesian priors and more.
}
