/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTableModel
extends AbstractTableModel {
    private TreeMap<Integer, Object[]> allData;
    private HashMap<Integer, Class> classes;
    private HashMap<Integer, Integer> columnMismatchCounter;
    private static final int MAXMISMATCH = 5;
    private boolean hasColnames = false;
    private int colnamesRowIndex = 0;
    private boolean hasRownames = false;
    private int rownamesColumnIndex = 0;
    private int maxColumnCount = 0;
    private int rowStart = 0;
    private int rowEnd = 0;
    private int colStart = 0;
    private int colEnd = 0;
    private boolean addingRow = false;
    private boolean clearing = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ImportTableModel() {
        this.allData = new TreeMap();
        this.classes = new HashMap();
        this.columnMismatchCounter = new HashMap();
    }

    @Override
    public int getRowCount() {
        if (this.allData.size() == 0) {
            return 0;
        }
        return this.rowEnd - this.rowStart + 1;
    }

    public int getRealRowIndex(int rowIndex) {
        return this.rowStart + rowIndex;
    }

    public int getMaxRowCount() {
        return this.allData.size();
    }

    @Override
    public String getColumnName(int column) {
        if (this.hasRownames && column == 0) {
            return "row.names";
        }
        if (this.hasColnames) {
            int colIndex = this.getRealColumnIndex(column);
            if (this.hasRownames && this.rownamesColumnIndex == 0 && this.allData.get(this.colnamesRowIndex).length + 1 == this.maxColumnCount) {
                --colIndex;
            }
            if (colIndex < this.allData.get(this.colnamesRowIndex).length) {
                return this.allData.get(this.colnamesRowIndex)[colIndex].toString();
            }
            return super.getColumnName(column);
        }
        return super.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.hasRownames && columnIndex == 0) {
            return Object.class;
        }
        return this.classes.get(this.getRealColumnIndex(columnIndex));
    }

    private boolean checkAllColumnClasses() {
        boolean returnval = false;
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            boolean flag = true;
            if (this.columnMismatchCounter.get(this.getRealColumnIndex(columnIndex)) >= 5) continue;
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                if (!(this.getValueAt(rowIndex, columnIndex) instanceof String)) continue;
                flag = false;
                if (this.classes.get(this.getRealColumnIndex(columnIndex)) != Double.class) break;
                this.classes.put(this.getRealColumnIndex(columnIndex), String.class);
                returnval = true;
                break;
            }
            if (!flag) continue;
            returnval = true;
            this.classes.put(this.getRealColumnIndex(columnIndex), Double.class);
        }
        return returnval;
    }

    private boolean checkColumnClass(int columnIndex) {
        if (this.columnMismatchCounter.get(this.getRealColumnIndex(columnIndex)) >= 5) {
            return false;
        }
        boolean returnval = false;
        boolean flag = true;
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            if (!(this.getValueAt(rowIndex, columnIndex) instanceof String)) continue;
            flag = false;
            break;
        }
        if (flag) {
            returnval = true;
            this.classes.put(this.getRealColumnIndex(columnIndex), Double.class);
        } else {
            this.classes.put(this.getRealColumnIndex(columnIndex), String.class);
        }
        return returnval;
    }

    @Override
    public int getColumnCount() {
        if (this.maxColumnCount == 0) {
            return 0;
        }
        if (this.hasRownames) {
            assert (this.colEnd - this.colStart + 2 <= this.maxColumnCount) : "colEnd: " + this.colEnd + " colStart: " + this.colStart;
            return this.colEnd - this.colStart + 2;
        }
        assert (this.colEnd - this.colStart + 1 <= this.maxColumnCount) : "getColumnCount() returns greater than maxcolumncount";
        return this.colEnd - this.colStart + 1;
    }

    private int getRealColumnIndex(int columnIndex) {
        if (this.hasRownames && columnIndex == 0) {
            return this.rownamesColumnIndex;
        }
        int realColIndex = this.colStart + columnIndex;
        if (this.hasRownames && realColIndex <= this.rownamesColumnIndex) {
            --realColIndex;
        }
        assert (realColIndex >= 0) : "realColIndex: " + realColIndex + " columnIndex: " + columnIndex;
        assert (realColIndex < this.getColumnCount() || this.getColumnCount() == 0) : "realColIndex is out ouf bound.\n realColIndex: " + realColIndex + " and column count: " + this.getColumnCount() + " columnIndex: " + columnIndex;
        return realColIndex;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.ensureRowArrayLength(rowIndex, columnIndex);
        Object oldValue = this.getValueAt(rowIndex, columnIndex);
        if (aValue != null && aValue instanceof String) {
            try {
                this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)rowIndex)))[this.getRealColumnIndex((int)columnIndex)] = aValue = Double.valueOf(Double.parseDouble(aValue.toString()));
                if (this.checkColumnClass(columnIndex)) {
                    this.fireTableStructureChanged();
                }
            }
            catch (NumberFormatException ex) {
                this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)rowIndex)))[this.getRealColumnIndex((int)columnIndex)] = aValue;
            }
        } else {
            this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)rowIndex)))[this.getRealColumnIndex((int)columnIndex)] = aValue;
        }
        if (oldValue != null && aValue != null) {
            if (!oldValue.equals(aValue)) {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        } else if (oldValue != null || aValue != null) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    private void ensureRowArrayLength(int rowIndex, int columnIndex) {
        int realRowIndex = this.getRealRowIndex(rowIndex);
        int realColumnIndex = this.getRealColumnIndex(columnIndex);
        if (realColumnIndex >= this.allData.get(realRowIndex).length) {
            Object[] oldrow = this.allData.get(realRowIndex);
            Object[] newrow = new Object[realColumnIndex + 1];
            System.arraycopy(oldrow, 0, newrow, 0, oldrow.length);
            this.allData.put(realRowIndex, newrow);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.allData.size() == 0) {
            return null;
        }
        rowIndex = this.getRealRowIndex(rowIndex);
        if ((columnIndex = this.getRealColumnIndex(columnIndex)) < this.allData.get(rowIndex).length) {
            return this.allData.get(rowIndex)[columnIndex];
        }
        return null;
    }

    public void addRow(List<String[]> rowData) {
        this.addingRow = true;
        int index = this.allData.size();
        for (String[] row : rowData) {
            Object[] newRow = this.convertRowAndSetColumnClasses(row);
            this.allData.put(index++, newRow);
            if (this.maxColumnCount >= row.length) continue;
            this.maxColumnCount = row.length;
            this.setColEnd(this.maxColumnCount - 1);
        }
        this.setRowEnd(this.allData.size() - 1);
        this.addingRow = false;
    }

    private Object[] convertRowAndSetColumnClasses(String[] row) {
        boolean flag = false;
        Object[] newRow = new Object[row.length];
        for (int i = 0; i < row.length; ++i) {
            int mismatchcount;
            if (!this.classes.containsKey(i)) {
                this.classes.put(i, Double.class);
                this.columnMismatchCounter.put(i, 0);
            }
            if ((mismatchcount = this.columnMismatchCounter.get(i).intValue()) < 5) {
                try {
                    if (row[i] == null || row[i].trim() == "" || row[i].trim().equalsIgnoreCase("NA") || row[i].trim().equalsIgnoreCase("NaN")) {
                        newRow[i] = null;
                        continue;
                    }
                    Double d = Double.parseDouble(row[i]);
                    newRow[i] = d;
                }
                catch (NumberFormatException ex) {
                    this.columnMismatchCounter.put(i, ++mismatchcount);
                    if (this.classes.get(i) != String.class) {
                        this.classes.put(i, String.class);
                        flag = true;
                    }
                    newRow[i] = row[i];
                }
                continue;
            }
            newRow[i] = row[i];
        }
        if (flag) {
            this.fireTableStructureChanged();
        }
        return newRow;
    }

    public boolean hasColumnNames() {
        return this.hasColnames;
    }

    public void setHasColumnNames(boolean hasColnames) {
        if (this.hasColnames != hasColnames) {
            boolean oldValue = this.hasColnames;
            this.hasColnames = hasColnames;
            if (!this.clearing) {
                if (hasColnames && this.rowStart <= this.colnamesRowIndex) {
                    this.setRowStart(this.colnamesRowIndex + 1);
                } else {
                    this.checkAllColumnClasses();
                }
                this.fireTableStructureChanged();
            }
            this.propertyChangeSupport.firePropertyChange(PROP.HASCOLUMNNAMES.name(), oldValue, this.hasColnames);
        }
    }

    public void setColumnNamesRowIndex(int colnamesRowIndex) {
        if (this.colnamesRowIndex != colnamesRowIndex) {
            int oldValue = this.colnamesRowIndex;
            this.colnamesRowIndex = colnamesRowIndex;
            if (this.hasColnames && this.rowStart <= this.colnamesRowIndex) {
                this.setRowStart(this.colnamesRowIndex + 1);
            }
            this.fireTableStructureChanged();
            this.propertyChangeSupport.firePropertyChange(PROP.COLUMNNAMESROWINDEX.name(), oldValue, this.colnamesRowIndex);
        }
    }

    public int getColumnNamesRowIndex() {
        return this.colnamesRowIndex;
    }

    public boolean hasRowNames() {
        return this.hasRownames;
    }

    public void setHasRowNames(boolean hasRownames) {
        if (this.hasRownames != hasRownames && this.maxColumnCount > 1) {
            boolean oldValue = this.hasRownames;
            this.hasRownames = hasRownames;
            if (this.colEnd > 0) {
                if (this.hasRownames && this.colEnd + 1 == this.maxColumnCount) {
                    this.setColEnd(this.colEnd - 1);
                } else {
                    this.setColEnd(this.colEnd + 1);
                }
            }
            this.propertyChangeSupport.firePropertyChange(PROP.HASROWNAMES.name(), oldValue, this.hasRownames);
        }
    }

    public void setRowNamesColumnIndex(int rowNamesColumnIndex) {
        if (this.rownamesColumnIndex != rowNamesColumnIndex) {
            int oldValue = this.rownamesColumnIndex;
            this.rownamesColumnIndex = rowNamesColumnIndex;
            if (this.hasRownames) {
                this.fireTableStructureChanged();
            }
            this.propertyChangeSupport.firePropertyChange(PROP.ROWNAMESCOLUMNINDEX.name(), oldValue, rowNamesColumnIndex);
        }
    }

    public void setRowStart(int rowStart) {
        if (this.rowStart != rowStart) {
            int oldStartValue = this.rowStart;
            this.rowStart = rowStart;
            if (oldStartValue < this.rowStart) {
                this.fireTableRowsDeleted(0, this.rowStart - oldStartValue - 1);
            } else {
                this.fireTableRowsInserted(0, oldStartValue - rowStart - 1);
            }
            if (!this.clearing && this.checkAllColumnClasses()) {
                this.fireTableStructureChanged();
            }
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_ROWSTART.name(), oldStartValue, this.rowStart);
        }
    }

    public int getRowStart() {
        return this.rowStart;
    }

    public void setRowEnd(int rowEnd) {
        if (this.rowEnd != rowEnd) {
            int oldEndValue = this.rowEnd;
            this.rowEnd = rowEnd;
            if (oldEndValue > this.rowEnd) {
                if (this.hasColnames) {
                    this.fireTableRowsDeleted(this.rowEnd - this.rowStart, oldEndValue - this.rowStart - 1);
                } else {
                    this.fireTableRowsDeleted(this.rowEnd - this.rowStart + 1, oldEndValue - this.rowStart);
                }
            } else if (this.hasColnames) {
                this.fireTableRowsInserted(oldEndValue - this.rowStart, this.rowEnd - this.rowStart - 1);
            } else {
                this.fireTableRowsInserted(oldEndValue - this.rowStart, this.rowEnd - this.rowStart);
            }
            if (!this.addingRow && !this.clearing && this.checkAllColumnClasses()) {
                this.fireTableStructureChanged();
            }
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_ROWEND.name(), oldEndValue, this.rowEnd);
        }
    }

    public int getRowEnd() {
        return this.rowEnd;
    }

    public void setColStart(int colStart) {
        if (this.colStart != colStart) {
            int oldValue = this.colStart;
            this.colStart = colStart;
            this.fireTableStructureChanged();
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_COLSTART.name(), oldValue, this.colStart);
        }
    }

    public int getColStart() {
        return this.colStart;
    }

    public void setColEnd(int colEnd) {
        if (this.colEnd != colEnd && colEnd < this.maxColumnCount) {
            int oldValue = this.colEnd;
            this.colEnd = colEnd;
            this.fireTableStructureChanged();
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_COLEND.name(), oldValue, this.colEnd);
        }
    }

    public int getColEnd() {
        return this.colEnd;
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public void clearAll() {
        this.clearing = true;
        this.setHasColumnNames(false);
        this.setColumnNamesRowIndex(0);
        this.setHasRowNames(false);
        this.setRowNamesColumnIndex(0);
        this.setRowStart(0);
        this.setRowEnd(0);
        this.setColStart(0);
        this.setColEnd(0);
        this.maxColumnCount = 0;
        this.allData.clear();
        this.classes.clear();
        this.columnMismatchCounter.clear();
        this.clearing = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public static void main(String[] args) throws Exception {
    }

    private static void fillModel(ImportTableModel model) {
        ArrayList<String[]> rowlist = new ArrayList<String[]>();
        String[] row = new String[]{"A1", "B1", "C1", "D1"};
        rowlist.add(row);
        row = new String[]{"1", "2", "3", "4", "5"};
        rowlist.add(row);
        row = new String[]{"6", "7", "8", "9", "10"};
        rowlist.add(row);
        row = new String[]{"11", "12", "13", "14", "15"};
        rowlist.add(row);
        row = new String[]{"16", "17", "18", "19", "20"};
        rowlist.add(row);
        row = new String[]{"21", "22", "23", "24", "ff"};
        rowlist.add(row);
        row = new String[]{"26", "27", "28", "29", "30"};
        rowlist.add(row);
        model.addRow(rowlist);
    }

    private static void writeTable(TableModel model) {
        int i;
        for (i = 0; i < model.getColumnCount(); ++i) {
            System.out.print(model.getColumnName(i) + "\t");
        }
        System.out.println("");
        for (i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                System.out.print(model.getValueAt(i, j) + "\t");
            }
            System.out.println("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROP {
        HASCOLUMNNAMES,
        COLUMNNAMESROWINDEX,
        HASROWNAMES,
        ROWNAMESCOLUMNINDEX,
        RANGE_ROWSTART,
        RANGE_ROWEND,
        RANGE_COLSTART,
        RANGE_COLEND;

    }
}

