/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.workspace;

import at.ac.arcs.tablefilter.ARCTable;
import java.text.NumberFormat;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.RList;

public class RUtil {
    private static NumberFormat nf;

    private static void initNumberFormatter() {
        nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(9);
    }

    private static REXPString createREXPString(ARCTable t, int columnIndex) {
        if (nf == null) {
            RUtil.initNumberFormatter();
        }
        String[] payload = new String[t.getRowCount()];
        for (int i = 0; i < payload.length; ++i) {
            Object valueAt = t.getValueAt(i, columnIndex);
            if (valueAt == null) continue;
            payload[i] = valueAt instanceof Double ? nf.format(valueAt) : valueAt.toString();
        }
        return new REXPString(payload);
    }

    private static REXPDouble createREXPDouble(ARCTable t, int columnIndex) {
        double[] payload = new double[t.getRowCount()];
        for (int i = 0; i < payload.length; ++i) {
            Object valueAt = t.getValueAt(i, columnIndex);
            if (valueAt == null) continue;
            payload[i] = (Double)valueAt;
        }
        return new REXPDouble(payload);
    }

    public static REXPGenericVector createRDataFrame(ARCTable arctable) {
        String[] names;
        REXP[] payload;
        REXPString rownamesREXPString = null;
        if (arctable.getColumnName(0).equals("row.names")) {
            rownamesREXPString = RUtil.createREXPString(arctable, 0);
        } else {
            String[] rn = new String[arctable.getRowCount()];
            for (int i = 0; i < rn.length; ++i) {
                rn[i] = "" + (i + 1);
            }
            rownamesREXPString = new REXPString(rn);
        }
        int i = 0;
        if (rownamesREXPString == null) {
            payload = new REXP[arctable.getColumnCount()];
            names = new String[arctable.getColumnCount()];
        } else {
            payload = new REXP[arctable.getColumnCount() - 1];
            names = new String[arctable.getColumnCount() - 1];
            i = 1;
        }
        int j = 0;
        while (i < arctable.getColumnCount()) {
            if (arctable.getColumnClass(i) == Double.class) {
                payload[j] = RUtil.createREXPDouble(arctable, i);
            } else if (arctable.getColumnClass(i) == String.class) {
                payload[j] = RUtil.createREXPString(arctable, i);
            }
            names[j] = arctable.getColumnName(i);
            ++i;
            ++j;
        }
        System.gc();
        REXPString namesREXPString = new REXPString(names);
        REXPString classREXPString = new REXPString("data.frame");
        REXPList attr = rownamesREXPString == null ? new REXPList(new RList(new REXP[]{namesREXPString, classREXPString}, new String[]{"names", "class"})) : new REXPList(new RList(new REXP[]{namesREXPString, classREXPString, rownamesREXPString}, new String[]{"names", "class", "row.names"}));
        return new REXPGenericVector(new RList(payload, names), attr);
    }
}

