/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.workspace;

import at.ac.ait.speedr.workspace.RConnection;
import at.ac.ait.speedr.workspace.RObject;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;

public class Workspace {
    private DefaultTreeModel workspace;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Objects");

    public Workspace() {
        this.workspace = new DefaultTreeModel(this.root);
    }

    public DefaultTreeModel getWorkspace() {
        return this.workspace;
    }

    public void reload() throws REngineException, REXPMismatchException {
        this.root.removeAllChildren();
        REXP exp = RConnection.eval(".reloadworkspace()");
        if (exp != null && !exp.isNull()) {
            if (exp.isList()) {
                RList metadata = exp.asList();
                this.addNodes(this.root, metadata);
            } else {
                System.err.println("isNotList");
            }
        }
        this.workspace.reload();
    }

    private void addNodes(DefaultMutableTreeNode node, RList metadata) throws REXPMismatchException {
        this.addNodes(node, metadata, null);
    }

    private void addNodes(DefaultMutableTreeNode node, RList metadata, RObject parent) throws REXPMismatchException {
        String[] var_name = metadata.at("var_name").asStrings();
        String[] var_cls = metadata.at("var_cls").asStrings();
        for (int i = 0; i < var_name.length; ++i) {
            RObject robj = new RObject(parent, var_name[i], var_cls[i]);
            if (robj.getType().equals("list") || robj.getType().equals("data.frame")) {
                DefaultMutableTreeNode listNode = new DefaultMutableTreeNode(robj, true);
                listNode.add(new DefaultMutableTreeNode("dummy"));
                node.add(listNode);
                continue;
            }
            node.add(new DefaultMutableTreeNode(robj, false));
        }
    }

    public REXP loadContent(String name) throws REngineException, REXPMismatchException {
        return RConnection.eval(name);
    }

    public void addListChildren(DefaultMutableTreeNode node) throws REngineException, REXPMismatchException {
        RObject ro = (RObject)node.getUserObject();
        REXP exp = RConnection.eval(".collectListOjectMetaData(" + ro.getName() + ")");
        if (exp.isList()) {
            RList metadata = exp.asList();
            node.removeAllChildren();
            this.addNodes(node, metadata, ro);
        } else {
            System.err.println("isNotList");
        }
    }

    public boolean hasVariable(String varname) {
        int count = this.workspace.getChildCount(this.root);
        for (int i = 0; i < count; ++i) {
            RObject var = (RObject)((DefaultMutableTreeNode)this.workspace.getChild(this.root, i)).getUserObject();
            if (!varname.equalsIgnoreCase(var.getName())) continue;
            return true;
        }
        return false;
    }

    public String getSummaryToolTip(RObject robject) throws REngineException, REXPMismatchException {
        REXP exp = RConnection.eval("capture.output(summary(" + robject.getName() + "))");
        String[] output = exp.asStrings();
        StringBuilder sum = new StringBuilder();
        sum.append("<html><pre>");
        for (String out : output) {
            sum.append(out).append("<br>");
        }
        sum.delete(sum.length() - 4, sum.length());
        sum.append("</pre></html>");
        return sum.toString();
    }
}

