/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.extension;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.extension.Extension;
import bibliothek.gui.dock.util.extension.ExtensionName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManager {
    private DockController controller;
    private List<Extension> extensions = new ArrayList<Extension>();
    private boolean alive = false;

    public ExtensionManager(DockController dockController) {
        this.controller = dockController;
        this.tryLoadDefaultExtensions();
    }

    protected void tryLoadDefaultExtensions() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"glass.eclipse.GlassExtension"}) {
            try {
                this.tryLoadExtension(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void tryLoadExtension(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(string);
        Object obj = clazz.newInstance();
        if (obj instanceof Extension) {
            this.add((Extension)obj);
        }
    }

    public void add(Extension extension) {
        this.extensions.add(extension);
        if (this.alive) {
            extension.install(this.controller);
        }
    }

    public void remove(Extension extension) {
        if (this.extensions.remove(extension) && this.alive) {
            extension.uninstall(this.controller);
        }
    }

    public Extension[] getExtensions() {
        return this.extensions.toArray(new Extension[this.extensions.size()]);
    }

    public <E> List<E> load(ExtensionName<E> extensionName) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Extension extension : this.extensions) {
            Collection<E> collection = extension.load(this.controller, extensionName);
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public void init() {
        this.alive = true;
        for (Extension extension : this.extensions) {
            extension.install(this.controller);
        }
    }

    public void kill() {
        if (this.alive) {
            this.alive = false;
            for (Extension extension : this.extensions) {
                extension.uninstall(this.controller);
            }
            this.extensions.clear();
        }
    }
}

