/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.BackupFactoryData;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedDockSituation
extends DockSituation {
    private Map<String, DockElement> stringToElement = new HashMap<String, DockElement>();
    private Map<DockElement, String> elementToString = new HashMap<DockElement, String>();
    private static final String KNOWN = "predefined";
    private static final String UNKNOWN = "delegate_";
    private Map<String, DockFactory<? extends DockElement, ?, BackupFactoryData<?>>> backups = new HashMap();
    private final PreloadFactory factory = new PreloadFactory();

    @Override
    public PredefinedPerspective createPerspective() {
        return new PredefinedPerspective(this){
            private PreloadFactory preload;
            {
                this.preload = new PreloadFactory(this);
            }

            @Override
            protected String getID(PerspectiveElement element) {
                return PredefinedDockSituation.this.getID(element, this);
            }

            @Override
            protected DockFactory<?, ?, ?> getFactory(String id) {
                DockFactory<? extends DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(id);
                if (factory == PredefinedDockSituation.this.factory) {
                    return this.preload;
                }
                return factory;
            }
        };
    }

    public void addBackup(DockFactory<? extends DockElement, ?, BackupFactoryData<?>> factory) {
        this.backups.put(UNKNOWN + factory.getID(), factory);
    }

    public void removeBackup(String id) {
        this.backups.remove(UNKNOWN + id);
    }

    @Deprecated
    public void put(DockElement element) {
        this.put(String.valueOf(this.stringToElement.size()), element);
    }

    public void put(String key, DockElement element) {
        if (this.stringToElement.containsKey(key)) {
            throw new IllegalArgumentException("Key does already exist: " + key);
        }
        this.stringToElement.put(key, element);
        this.elementToString.put(element, key);
    }

    protected boolean shouldLayout(DockElement element) {
        return true;
    }

    protected boolean shouldLayout(PerspectiveElement element, PredefinedPerspective perspective) {
        DockElement dock;
        String key = perspective.get(element);
        if (key != null && (dock = this.stringToElement.get(key)) != null) {
            return this.shouldLayout(dock);
        }
        return true;
    }

    @Override
    protected DockLayoutInfo fillMissing(DockLayoutInfo info) {
        DockLayout<?> layout = info.getDataLayout();
        if (KNOWN.equals(layout.getFactoryID())) {
            PreloadedLayout preloaded = (PreloadedLayout)layout.getData();
            DockLayoutInfo delegate = preloaded.getDelegate();
            DockLayoutInfo newDelegate = null;
            if (delegate.getKind() == DockLayoutInfo.Data.BYTE) {
                newDelegate = this.fillMissingStream(preloaded);
            } else if (delegate.getKind() == DockLayoutInfo.Data.XML) {
                newDelegate = this.fillMissingXML(preloaded);
            }
            if (newDelegate != null) {
                info = new DockLayoutInfo(new DockLayout<PreloadedLayout>(KNOWN, new PreloadedLayout(preloaded.getPreload(), newDelegate)));
            }
        }
        return info;
    }

    public <D extends DockElement> Set<D> listVisible(Collection<D> base, DockLayoutComposition composition) {
        HashSet result = new HashSet();
        this.listVisible(base, composition, result);
        return result;
    }

    private <D extends DockElement> void listVisible(final Collection<D> base, DockLayoutComposition composition, final Set<D> result) {
        PreloadedLayout preload;
        String key;
        DockElement element;
        DockLayout<?> layout;
        DockLayoutInfo info = composition.getLayout();
        if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && KNOWN.equals((layout = info.getDataLayout()).getFactoryID()) && (element = this.stringToElement.get(key = (preload = (PreloadedLayout)layout.getData()).getPreload())) != null) {
            if (base.contains(element)) {
                result.add(element);
            }
            if (composition.isIgnoreChildren()) {
                DockUtilities.visit(element, new DockUtilities.DockVisitor(){

                    public void handleDockable(Dockable dockable) {
                        if (base.contains(dockable)) {
                            result.add(dockable);
                        }
                    }

                    public void handleDockStation(DockStation station) {
                        if (base.contains(station)) {
                            result.add(station);
                        }
                    }
                });
            }
        }
        for (DockLayoutComposition child : composition.getChildren()) {
            this.listVisible(base, child, result);
        }
    }

    public Map<String, DockableProperty> listEstimatedLocations(DockLayoutComposition composition, boolean missingOnly) {
        return this.listEstimatedLocations(composition, composition.getLayout().getLocation(), missingOnly);
    }

    public Map<String, DockableProperty> listEstimatedLocations(DockLayoutComposition composition, DockableProperty location, boolean missingOnly) {
        String key;
        this.estimateLocations(composition, location);
        HashMap<String, DockableProperty> map = new HashMap<String, DockableProperty>();
        this.listEstimatedLocations(composition, missingOnly, map);
        if (location != null && (key = this.getKey(composition, missingOnly)) != null) {
            map.put(key, location);
        }
        return map;
    }

    private void listEstimatedLocations(DockLayoutComposition composition, boolean missingOnly, Map<String, DockableProperty> map) {
        List<DockLayoutComposition> children;
        String key;
        DockableProperty location = composition.getLayout().getLocation();
        if (location != null && (key = this.getKey(composition, missingOnly)) != null) {
            map.put(key, location);
        }
        if ((children = composition.getChildren()) != null) {
            for (DockLayoutComposition child : children) {
                this.listEstimatedLocations(child, missingOnly, map);
            }
        }
    }

    public Map<String, DockLayoutComposition> listLayouts(DockLayoutComposition composition, boolean missingOnly) {
        HashMap<String, DockLayoutComposition> map = new HashMap<String, DockLayoutComposition>();
        this.listLayouts(composition, missingOnly, map);
        return map;
    }

    private void listLayouts(DockLayoutComposition composition, boolean missingOnly, Map<String, DockLayoutComposition> map) {
        List<DockLayoutComposition> children;
        String key = this.getKey(composition, missingOnly);
        if (key != null) {
            map.put(key, composition);
        }
        if ((children = composition.getChildren()) != null) {
            for (DockLayoutComposition child : children) {
                this.listLayouts(child, missingOnly, map);
            }
        }
    }

    private String getKey(DockLayoutComposition composition, boolean missingOnly) {
        DockLayoutInfo layout = composition.getLayout();
        if (layout.getKind() != DockLayoutInfo.Data.DOCK_LAYOUT) {
            return null;
        }
        if (!KNOWN.equals(layout.getDataLayout().getFactoryID())) {
            return null;
        }
        PreloadedLayout preloaded = (PreloadedLayout)layout.getDataLayout().getData();
        if (missingOnly && preloaded.getDelegate().getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && this.stringToElement.containsKey(preloaded.getPreload())) {
            return null;
        }
        String key = preloaded.getPreload();
        return key;
    }

    private DockLayoutInfo fillMissingStream(PreloadedLayout layout) {
        byte[] bytes = layout.getDelegate().getDataByte();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            String factoryId = in.readUTF();
            DockFactory<DockElement, ?, ?> factory = this.getFactory(factoryId);
            DockLayoutInfo info = null;
            if (factory == null) {
                BackupFactoryData data;
                DockFactory<DockElement, ?, BackupFactoryData<?>> backup = this.getBackup(factoryId);
                if (backup != null && (data = (BackupFactoryData)backup.read(in, this.getPlaceholderStrategy())) != null && data.getData() != null) {
                    info = new DockLayoutInfo(new DockLayout(factoryId, data.getData()));
                }
            } else {
                Object delegate = factory.read(in, this.getPlaceholderStrategy());
                if (delegate != null) {
                    info = new DockLayoutInfo(new DockLayout(factoryId, delegate));
                }
            }
            in.close();
            return info;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot read stream", ex);
        }
    }

    private DockLayoutInfo fillMissingXML(PreloadedLayout layout) {
        XElement xdelegate = layout.getDelegate().getDataXML();
        String factoryId = xdelegate.getString("id");
        Object delegate = null;
        DockFactory<DockElement, ?, ?> factory = this.getFactory(factoryId);
        if (factory == null) {
            BackupFactoryData data;
            DockFactory<DockElement, ?, BackupFactoryData<?>> backup = this.getBackup(factoryId);
            if (backup != null && (data = (BackupFactoryData)backup.read(xdelegate, this.getPlaceholderStrategy())) != null) {
                delegate = data.getData();
            }
        } else {
            delegate = factory.read(xdelegate, this.getPlaceholderStrategy());
        }
        if (delegate == null) {
            return null;
        }
        return new DockLayoutInfo(new DockLayout<Object>(factoryId, delegate));
    }

    protected String getID(PerspectiveElement element, PredefinedPerspective perspective) {
        String key = perspective.get(element);
        if (key == null) {
            return UNKNOWN + super.getID(element);
        }
        return KNOWN;
    }

    @Override
    public String getID(DockElement dockable) {
        String key = this.elementToString.get(dockable);
        if (key == null) {
            return UNKNOWN + super.getID(dockable);
        }
        return KNOWN;
    }

    @Override
    protected String getID(DockFactory<?, ?, ?> factory) {
        if (factory == this.factory) {
            return KNOWN;
        }
        return UNKNOWN + super.getID(factory);
    }

    @Override
    protected String getFactoryID(String id) {
        if (KNOWN.equals(id)) {
            return this.factory.getID();
        }
        return id.substring(UNKNOWN.length());
    }

    public static String convertFactoryID(String id) {
        return UNKNOWN + id;
    }

    @Override
    public DockFactory<? extends DockElement, ?, ?> getFactory(String id) {
        if (KNOWN.equals(id)) {
            return this.factory;
        }
        return super.getFactory(id);
    }

    protected DockFactory<? extends DockElement, ?, BackupFactoryData<?>> getBackup(String id) {
        return this.backups.get(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreloadFactory
    implements DockFactory<DockElement, PerspectiveElement, PreloadedLayout> {
        private PredefinedPerspective perspective;

        public PreloadFactory() {
        }

        public PreloadFactory(PredefinedPerspective perspective) {
            this.perspective = perspective;
        }

        @Override
        public String getID() {
            return PredefinedDockSituation.KNOWN;
        }

        @Override
        public void estimateLocations(PreloadedLayout layout, LocationEstimationMap children) {
            String factoryId;
            DockFactory<DockElement, ?, ?> factory;
            DockLayoutInfo delegate = layout.getDelegate();
            if (delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && (factory = PredefinedDockSituation.this.getFactory(factoryId = delegate.getDataLayout().getFactoryID())) != null) {
                factory.estimateLocations(delegate.getDataLayout().getData(), children);
            }
        }

        @Override
        public PreloadedLayout getLayout(DockElement element, Map<Dockable, Integer> children) {
            if (PredefinedDockSituation.this.shouldLayout(element)) {
                String factoryId = PredefinedDockSituation.UNKNOWN + PredefinedDockSituation.super.getID(element);
                DockFactory<DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(factoryId);
                if (factory == null) {
                    throw new IllegalStateException("Missing factory: " + factoryId);
                }
                Object data = factory.getLayout(element, children);
                DockLayout layout = new DockLayout(factoryId, data);
                return new PreloadedLayout((String)PredefinedDockSituation.this.elementToString.get(element), new DockLayoutInfo(layout));
            }
            return new PreloadedLayout((String)PredefinedDockSituation.this.elementToString.get(element), new DockLayoutInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLayout(DockElement element, PreloadedLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
            String factoryId;
            DockFactory<DockElement, ?, ?> factory;
            DockLayoutInfo delegate = layout.getDelegate();
            if (delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(element) && (factory = PredefinedDockSituation.this.getFactory(factoryId = delegate.getDataLayout().getFactoryID())) != null) {
                DockController controller = element.getController();
                try {
                    if (controller != null) {
                        controller.freezeLayout();
                    }
                    factory.setLayout(element, delegate.getDataLayout().getData(), children, placeholders);
                }
                finally {
                    if (controller != null) {
                        controller.meltLayout();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLayout(DockElement element, PreloadedLayout layout, PlaceholderStrategy placeholders) {
            String factoryId;
            DockFactory<DockElement, ?, ?> factory;
            DockLayoutInfo delegate = layout.getDelegate();
            if (delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(element) && (factory = PredefinedDockSituation.this.getFactory(factoryId = delegate.getDataLayout().getFactoryID())) != null) {
                DockController controller = element.getController();
                try {
                    if (controller != null) {
                        controller.freezeLayout();
                    }
                    factory.setLayout(element, delegate.getDataLayout().getData(), placeholders);
                }
                finally {
                    if (controller != null) {
                        controller.meltLayout();
                    }
                }
            }
        }

        @Override
        public DockElement layout(PreloadedLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
            boolean isNull;
            DockLayoutInfo delegate = layout.getDelegate();
            boolean isLayout = delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl = isNull = delegate.getKind() == DockLayoutInfo.Data.NULL;
            if (!isLayout && !isNull) {
                return null;
            }
            DockElement element = (DockElement)PredefinedDockSituation.this.stringToElement.get(layout.getPreload());
            if (element == null && isLayout) {
                String factoryId = delegate.getDataLayout().getFactoryID();
                DockFactory<DockElement, ?, BackupFactoryData<?>> factory = PredefinedDockSituation.this.getBackup(factoryId);
                if (factory != null) {
                    return factory.layout(new BackupFactoryData(layout.getPreload(), delegate.getDataLayout().getData()), children, placeholders);
                }
                return null;
            }
            this.setLayout(element, layout, children, placeholders);
            return element;
        }

        @Override
        public DockElement layout(PreloadedLayout layout, PlaceholderStrategy placeholders) {
            boolean isNull;
            DockLayoutInfo delegate = layout.getDelegate();
            boolean isLayout = delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl = isNull = delegate.getKind() == DockLayoutInfo.Data.NULL;
            if (!isLayout && !isNull) {
                return null;
            }
            DockElement element = (DockElement)PredefinedDockSituation.this.stringToElement.get(layout.getPreload());
            if (element == null && isLayout) {
                if (layout.getDelegate() == null) {
                    return null;
                }
                String factoryId = delegate.getDataLayout().getFactoryID();
                DockFactory<DockElement, ?, BackupFactoryData<?>> factory = PredefinedDockSituation.this.getBackup(factoryId);
                if (factory != null) {
                    return factory.layout(new BackupFactoryData(layout.getPreload(), delegate.getDataLayout().getData()), placeholders);
                }
                return null;
            }
            this.setLayout(element, layout, placeholders);
            return element;
        }

        @Override
        public PerspectiveElement layoutPerspective(PreloadedLayout layout, Map<Integer, PerspectiveDockable> children) {
            boolean isNull;
            if (this.perspective == null) {
                throw new IllegalStateException("the perspective of this factory is not set, meaning this factory cannot be used handling perspective dependent tasks");
            }
            DockLayoutInfo delegate = layout.getDelegate();
            boolean isLayout = delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl = isNull = delegate.getKind() == DockLayoutInfo.Data.NULL;
            if (!isLayout && !isNull) {
                return null;
            }
            PerspectiveElement element = this.perspective.get(layout.getPreload());
            if (element == null && isLayout) {
                String factoryId = delegate.getDataLayout().getFactoryID();
                DockFactory<DockElement, ?, BackupFactoryData<?>> factory = PredefinedDockSituation.this.getBackup(factoryId);
                if (factory != null) {
                    return factory.layoutPerspective(new BackupFactoryData(layout.getPreload(), delegate.getDataLayout().getData()), children);
                }
                return null;
            }
            this.layoutPerspective(element, layout, children);
            return element;
        }

        @Override
        public void layoutPerspective(PerspectiveElement element, PreloadedLayout layout, Map<Integer, PerspectiveDockable> children) {
            String factoryId;
            DockFactory<DockElement, ?, ?> factory;
            DockLayoutInfo delegate = layout.getDelegate();
            if (delegate.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(element, this.perspective) && (factory = PredefinedDockSituation.this.getFactory(factoryId = delegate.getDataLayout().getFactoryID())) != null) {
                factory.layoutPerspective(element, delegate.getDataLayout().getData(), children);
            }
        }

        @Override
        public PreloadedLayout getPerspectiveLayout(PerspectiveElement element, Map<PerspectiveDockable, Integer> children) {
            DockLayoutInfo info;
            if (this.perspective == null) {
                throw new IllegalStateException("the perspective of this factory is not set, meaning this factory cannot be used handling perspective dependent tasks");
            }
            if (PredefinedDockSituation.this.shouldLayout(element, this.perspective)) {
                String factoryId = PredefinedDockSituation.UNKNOWN + PredefinedDockSituation.super.getID(element);
                DockFactory<DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(factoryId);
                if (factory == null) {
                    throw new IllegalStateException("Missing factory: " + factoryId);
                }
                Object data = factory.getPerspectiveLayout(element, children);
                DockLayout layout = new DockLayout(factoryId, data);
                info = new DockLayoutInfo(layout);
            } else {
                info = new DockLayoutInfo();
            }
            String key = this.perspective.get(element);
            if (key == null) {
                throw new IllegalStateException("Expected a key for an element, the element should be known to the perspective, otherwise this method would not have been called: '" + element + "'");
            }
            return new PreloadedLayout(key, info);
        }

        @Override
        public void write(PreloadedLayout layout, DataOutputStream out) throws IOException {
            Version.write(out, Version.VERSION_1_0_7);
            DockLayoutInfo info = layout.getDelegate();
            out.writeUTF(layout.getPreload());
            if (info.getKind() == DockLayoutInfo.Data.BYTE) {
                out.writeBoolean(true);
                out.write(info.getDataByte());
            } else if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
                out.writeBoolean(true);
                DockLayout<?> delegate = info.getDataLayout();
                String factoryId = delegate.getFactoryID();
                DockFactory<DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(factoryId);
                if (factory == null) {
                    throw new IOException("Missing factory: " + factoryId);
                }
                out.writeUTF(factoryId);
                factory.write(delegate.getData(), out);
            } else if (info.getKind() == DockLayoutInfo.Data.NULL) {
                out.writeBoolean(false);
            } else {
                throw new IllegalArgumentException("Cannot store information as byte[], it is not present as raw byte[] or in an understandable format");
            }
        }

        @Override
        public PreloadedLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
            Version version = Version.read(in);
            version.checkCurrent();
            boolean version7 = Version.VERSION_1_0_7.compareTo(version) <= 0;
            String preloaded = in.readUTF();
            boolean nullValue = false;
            if (version7) {
                nullValue = !in.readBoolean();
            }
            DockLayoutInfo info = null;
            if (nullValue) {
                info = new DockLayoutInfo();
            } else {
                String factoryId = in.readUTF();
                DockFactory<DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(factoryId);
                if (factory == null) {
                    DockFactory<DockElement, ?, BackupFactoryData<?>> backup = PredefinedDockSituation.this.getBackup(factoryId);
                    if (backup != null) {
                        BackupFactoryData data = (BackupFactoryData)backup.read(in, placeholders);
                        if (data != null && data.getData() != null) {
                            info = new DockLayoutInfo(new DockLayout(factoryId, data.getData()));
                        }
                    } else {
                        int read;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DataOutputStream dout = new DataOutputStream(out);
                        dout.writeUTF(factoryId);
                        while ((read = in.read()) != -1) {
                            dout.write(read);
                        }
                        dout.close();
                        info = new DockLayoutInfo(out.toByteArray());
                    }
                } else {
                    Object delegate = factory.read(in, placeholders);
                    if (delegate != null) {
                        info = new DockLayoutInfo(new DockLayout(factoryId, delegate));
                    }
                }
            }
            if (info == null) {
                return null;
            }
            return new PreloadedLayout(preloaded, info);
        }

        @Override
        public void write(PreloadedLayout layout, XElement element) {
            element.addElement("replacement").addString("id", layout.getPreload());
            DockLayoutInfo info = layout.getDelegate();
            if (info.getKind() == DockLayoutInfo.Data.XML) {
                element.addElement(info.getDataXML());
            } else if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
                DockLayout<?> delegate = layout.getDelegate().getDataLayout();
                String factoryId = delegate.getFactoryID();
                DockFactory<DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(factoryId);
                if (factory == null) {
                    throw new XException("Missing factory: " + factoryId);
                }
                XElement xdelegate = element.addElement("delegate");
                xdelegate.addString("id", factoryId);
                factory.write(delegate.getData(), xdelegate);
            } else if (info.getKind() != DockLayoutInfo.Data.NULL) {
                throw new IllegalArgumentException("Cannot store information as xml, it is neither present as raw xml nor in an understandable format");
            }
        }

        @Override
        public PreloadedLayout read(XElement element, PlaceholderStrategy placeholders) {
            String preload = element.getElement("replacement").getString("id");
            XElement xdelegate = element.getElement("delegate");
            if (xdelegate == null) {
                return new PreloadedLayout(preload, new DockLayoutInfo());
            }
            String factoryId = xdelegate.getString("id");
            Object delegate = null;
            DockFactory<DockElement, ?, ?> factory = PredefinedDockSituation.this.getFactory(factoryId);
            if (factory == null) {
                BackupFactoryData data;
                DockFactory<DockElement, ?, BackupFactoryData<?>> backup = PredefinedDockSituation.this.getBackup(factoryId);
                if (backup != null && (data = (BackupFactoryData)backup.read(xdelegate, placeholders)) != null) {
                    delegate = data.getData();
                }
            } else {
                delegate = factory.read(xdelegate, placeholders);
            }
            if (delegate == null) {
                return new PreloadedLayout(preload, new DockLayoutInfo(xdelegate));
            }
            DockLayout<Object> layout = new DockLayout<Object>(factoryId, delegate);
            return new PreloadedLayout(preload, new DockLayoutInfo(layout));
        }
    }

    private static class PreloadedLayout {
        private DockLayoutInfo delegate;
        private String preload;

        public PreloadedLayout(String preload, DockLayoutInfo delegate) {
            if (preload == null) {
                throw new IllegalArgumentException("argument 'preload' must not be null");
            }
            this.preload = preload;
            this.delegate = delegate;
        }

        public String getPreload() {
            return this.preload;
        }

        public DockLayoutInfo getDelegate() {
            return this.delegate;
        }
    }
}

