/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.LayoutLocked;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockUtilities {
    private static boolean checkLayoutLock = true;

    public static void visit(Dockable dockable, DockVisitor visitor) {
        DockUtilities.visitDockable(dockable, visitor);
    }

    public static void visit(DockStation station, DockVisitor visitor) {
        Dockable dockable = station.asDockable();
        if (dockable != null) {
            DockUtilities.visitDockable(dockable, visitor);
        } else {
            DockUtilities.visitStation(station, visitor);
        }
    }

    public static void visit(DockElement element, DockVisitor visitor) {
        Dockable dockable = element.asDockable();
        if (dockable != null) {
            DockUtilities.visitDockable(dockable, visitor);
        } else {
            DockStation station = element.asDockStation();
            if (station != null) {
                DockUtilities.visitStation(station, visitor);
            }
        }
    }

    private static void visitDockable(Dockable dockable, DockVisitor visitor) {
        visitor.handleDockable(dockable);
        DockStation station = dockable.asDockStation();
        if (station != null) {
            DockUtilities.visitStation(station, visitor);
        }
    }

    private static void visitStation(DockStation station, DockVisitor visitor) {
        visitor.handleDockStation(station);
        Dockable[] children = new Dockable[station.getDockableCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = station.getDockable(i);
        }
        for (Dockable child : children) {
            DockUtilities.visitDockable(child, visitor);
        }
    }

    public static List<Dockable> listDockables(final DockElement root, final boolean includeRoot) {
        final ArrayList<Dockable> list = new ArrayList<Dockable>();
        DockUtilities.visit(root, new DockVisitor(){

            public void handleDockable(Dockable dockable) {
                if (includeRoot || dockable != root) {
                    list.add(dockable);
                }
            }
        });
        return list;
    }

    public static boolean isAncestor(DockElement ancestor, DockElement child) {
        if (ancestor == null) {
            throw new NullPointerException("ancestor must not be null");
        }
        if (child == null) {
            throw new NullPointerException("child must not be null");
        }
        Dockable dockable = child.asDockable();
        DockStation station = null;
        while (dockable != null) {
            if (ancestor == dockable) {
                return true;
            }
            station = dockable.getDockParent();
            dockable = station == null ? null : station.asDockable();
        }
        return station == ancestor;
    }

    public static boolean isAncestor(PerspectiveElement ancestor, PerspectiveElement child) {
        if (ancestor == null) {
            throw new NullPointerException("ancestor must not be null");
        }
        if (child == null) {
            throw new NullPointerException("child must not be null");
        }
        PerspectiveDockable dockable = child.asDockable();
        PerspectiveStation station = null;
        while (dockable != null) {
            if (ancestor == dockable) {
                return true;
            }
            station = dockable.getParent();
            dockable = station == null ? null : station.asDockable();
        }
        return station == ancestor;
    }

    public static DockStation getRoot(DockElement element) {
        Dockable dockable = element.asDockable();
        if (dockable == null) {
            return element.asDockStation();
        }
        DockStation parent = dockable.getDockParent();
        if (parent == null) {
            return element.asDockStation();
        }
        while ((dockable = parent.asDockable()) != null && dockable.getDockParent() != null) {
            parent = dockable.getDockParent();
        }
        return parent;
    }

    public static Dockable getDirectChild(DockStation parent, Dockable subchild) {
        DockStation subparent = subchild.getDockParent();
        while (subparent != null) {
            if (subparent == parent) {
                return subchild;
            }
            subchild = subparent.asDockable();
            subparent = subchild == null ? null : subchild.getDockParent();
        }
        return null;
    }

    public static DockableProperty append(DockableProperty root, DockableProperty property) {
        if (root == null) {
            return property;
        }
        root = root.copy();
        DockUtilities.getLastProperty(root).setSuccessor(property);
        return root;
    }

    public static DockableProperty getLastProperty(DockableProperty property) {
        while (property.getSuccessor() != null) {
            property = property.getSuccessor();
        }
        return property;
    }

    public static DockableProperty getPropertyChain(Dockable dockable) {
        DockStation station = DockUtilities.getRoot(dockable);
        if (station == null || station == dockable) {
            return null;
        }
        return DockUtilities.getPropertyChain(station, dockable);
    }

    public static DockableProperty getPropertyChain(DockStation ground, Dockable dockable) {
        if (ground == dockable) {
            throw new IllegalArgumentException("ground and dockable are the same");
        }
        DockStation parent = dockable.getDockParent();
        DockableProperty property = parent.getDockableProperty(dockable, dockable);
        Dockable child = dockable;
        while (parent != ground) {
            child = parent.asDockable();
            if (child == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            parent = child.getDockParent();
            if (parent == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            DockableProperty temp = parent.getDockableProperty(child, dockable);
            temp.setSuccessor(property);
            property = temp;
        }
        return property;
    }

    public static DockableProperty getPropertyChain(PerspectiveStation ground, PerspectiveDockable dockable) {
        if (ground == dockable) {
            throw new IllegalArgumentException("ground and dockable are the same");
        }
        PerspectiveStation parent = dockable.getParent();
        DockableProperty property = parent.getDockableProperty(dockable, dockable);
        PerspectiveDockable child = dockable;
        while (parent != ground) {
            child = parent.asDockable();
            if (child == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            parent = child.getParent();
            if (parent == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            DockableProperty temp = parent.getDockableProperty(child, dockable);
            temp.setSuccessor(property);
            property = temp;
        }
        return property;
    }

    public static Component getShowingComponent(Dockable dockable) {
        Component component = dockable.getComponent();
        if (!component.isShowing()) {
            DockTitle title;
            DockTitle[] arr$ = dockable.listBoundTitles();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(component = (title = arr$[i$]).getComponent()).isShowing(); ++i$) {
            }
        }
        if (component.isShowing()) {
            return component;
        }
        return null;
    }

    public static void ensureTreeValidity(DockStation newParent, Dockable newChild) {
        if (newParent == null) {
            throw new NullPointerException("parent must not be null");
        }
        if (newChild == null) {
            throw new NullPointerException("child must not be null");
        }
        DockStation oldParent = newChild.getDockParent();
        if (newChild == newParent) {
            throw new IllegalArgumentException("child and parent are the same");
        }
        if (DockUtilities.isAncestor(newChild, newParent)) {
            throw new IllegalArgumentException("can't create a cycle");
        }
        if (oldParent != null) {
            if (oldParent != newParent && !oldParent.canDrag(newChild)) {
                throw new IllegalStateException("old parent of child does not want do release the child");
            }
            oldParent.drag(newChild);
        }
    }

    public static void ensureTreeValidity(PerspectiveStation newParent, PerspectiveDockable newChild) {
        if (newParent == null) {
            throw new NullPointerException("parent must not be null");
        }
        if (newChild == null) {
            throw new NullPointerException("child must not be null");
        }
        PerspectiveStation oldParent = newChild.getParent();
        if (newChild == newParent) {
            throw new IllegalArgumentException("child and parent are the same");
        }
        if (DockUtilities.isAncestor(newChild, newParent)) {
            throw new IllegalArgumentException("can't create a cycle");
        }
        if (oldParent != null && oldParent != newParent) {
            oldParent.remove(newChild);
        }
    }

    public static Icon disabledIcon(JComponent parent, Icon icon) {
        if (icon == null) {
            return null;
        }
        Icon result = UIManager.getLookAndFeel().getDisabledIcon(parent, icon);
        if (result != null) {
            return result;
        }
        if (parent != null) {
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(parent, g, 0, 0);
            g.dispose();
            icon = new ImageIcon(image);
            result = UIManager.getLookAndFeel().getDisabledIcon(parent, icon);
        }
        if (result != null) {
            return result;
        }
        return icon;
    }

    public static Image iconImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public static Map<String, Icon> loadIcons(String list, String path, ClassLoader loader) {
        return DockUtilities.loadIcons(list, path, null, loader);
    }

    public static Map<String, Icon> loadIcons(String list, String path, Set<String> ignore, ClassLoader loader) {
        try {
            InputStream in = loader.getResourceAsStream(list);
            if (in == null) {
                return new HashMap<String, Icon>();
            }
            Properties properties = new Properties();
            properties.load(in);
            in.close();
            HashMap<String, Icon> result = new HashMap<String, Icon>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                URL url;
                String key = (String)entry.getKey();
                if (ignore != null && ignore.contains(key)) continue;
                String file = (String)entry.getValue();
                if (path != null) {
                    file = path + file;
                }
                if ((url = loader.getResource(file)) == null) {
                    System.err.println("Missing file: " + file);
                    continue;
                }
                ImageIcon icon = new ImageIcon(url);
                result.put(key, icon);
            }
            return result;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new HashMap<String, Icon>();
        }
    }

    public static Path[] mergePlaceholders(Path[] base, Dockable dockable, PlaceholderStrategy strategy) {
        if (dockable == null || strategy == null) {
            return base;
        }
        Path placeholder = strategy.getPlaceholderFor(dockable);
        if (placeholder == null) {
            return base;
        }
        if (base == null) {
            return new Path[]{placeholder};
        }
        for (Path check : base) {
            if (!placeholder.equals(check)) continue;
            return base;
        }
        Path[] result = new Path[base.length + 1];
        System.arraycopy(base, 0, result, 0, base.length);
        result[base.length] = placeholder;
        return result;
    }

    public static void disableCheckLayoutLocked() {
        checkLayoutLock = false;
    }

    public static void checkLayoutLocked() {
        if (checkLayoutLock) {
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            HashSet tested = new HashSet();
            for (StackTraceElement element : elements) {
                try {
                    Class<?> clazz = Class.forName(element.getClassName());
                    if (DockUtilities.checkLayoutLocked(clazz, tested)) {
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean checkLayoutLocked(Class<?> clazz, Set<Class<?>> tested) {
        if (clazz != null && tested.add(clazz)) {
            LayoutLocked locked = clazz.getAnnotation(LayoutLocked.class);
            if (locked != null) {
                if (locked.locked()) {
                    System.err.println("Warning: layout should not be modified by subclasses of " + clazz.getName());
                    System.err.println(" This is only an information, not an exception. If your code is actually safe you can:");
                    System.err.println(" - disabled the warning by calling DockUtilities.disableCheckLayoutLocked() )");
                    System.err.println(" - mark your code as safe by setting the annotation 'LayoutLocked'");
                    for (StackTraceElement item : Thread.currentThread().getStackTrace()) {
                        System.err.println(item);
                    }
                }
                return true;
            }
            boolean result = DockUtilities.checkLayoutLocked(clazz.getSuperclass(), tested);
            if (result) {
                return result;
            }
            for (Class<?> interfaze : clazz.getInterfaces()) {
                result = DockUtilities.checkLayoutLocked(interfaze, tested);
                if (!result) continue;
                return result;
            }
        }
        return false;
    }

    public static abstract class DockVisitor {
        public void handleDockable(Dockable dockable) {
        }

        public void handleDockStation(DockStation station) {
        }
    }
}

