% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{A_theta_x}
\alias{A_theta_x}
\title{Surface area of the intersection of two hyperspherical caps}
\usage{
A_theta_x(theta, x, p, N = 160L, as_matrix = TRUE)
}
\arguments{
\item{theta}{vectors with values in \eqn{[0, \pi]}.}

\item{x}{vector with values in \eqn{[-1, 1]}.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{N}{number of points used in the
\link[=Gauss_Legen_nodes]{Gauss-Legendre quadrature}. Defaults to
\code{160}.}

\item{as_matrix}{return a matrix with the values of \eqn{A_x(\theta)} on
the grid formed by \code{theta} and \code{x}? If \code{FALSE},
\eqn{A_x(\theta)} is evaluated on \code{theta} and \code{x} if they equal
in size. Defaults to \code{TRUE}.}
}
\value{
A matrix of size \code{c(length(theta), length(x))} containing the
evaluation of \eqn{A_x(\theta)} if \code{as_matrix = TRUE}. Otherwise,
a vector of size \code{c(length(theta)} if \code{theta} and \code{x} equal
in size.
}
\description{
Computation of
\deqn{A_x(\theta_{ij}) := \frac{1}{\omega_p}
\int_{S^{p - 1}} 1_{\{{\bf X}_i'\boldsymbol\gamma \le x,
{\bf X}_j'\boldsymbol\gamma \le x\}}\,\mathrm{d}\boldsymbol\gamma,}{
A_x(\theta_{ij}) := \frac{1}{\omega_p} \int_{S^{p - 1}}
1_{X_i'\gamma \le x, X_j'\gamma \le x} d\gamma,}
where \eqn{\theta_{ij} := \cos^{-1}({\bf X}_i'{\bf X}_j)
\in [0, \pi]}{\theta_{ij} := \cos^{-1}(X_i'X_j) \in [0, \pi]},
\eqn{x \in [-1, 1]}, and \eqn{\omega_{p}} is the surface area of
\eqn{S^{p - 1}}. \eqn{A_x(\theta_{ij})} is the proportion of surface area
of \eqn{S^{p - 1}} covered by the intersection of two hyperspherical caps
centered at \eqn{{\bf X}_i}{X_i} and \eqn{{\bf X}_j}{X_j} and with
common solid angle \eqn{\pi - \cos^{-1}(x)}.
}
\details{
See García-Portugués et al. (2020) for more details about the
\eqn{A_x(\theta)} function.
}
\examples{
# Plot A_x(theta) for several dimensions and x's
A_lines <- function(x, th = seq(0, pi, l = 200)) {

  plot(th, A_theta_x(theta = th, x = x, p = 2), type = "l",
       col = 1, ylim = c(0, 1.25), main = paste("x =", x),
       ylab = expression(A[x](theta)),
       xlab = expression(theta), axes = FALSE)
  axis(1, at = c(0, pi / 4, pi / 2, 3 * pi / 4, pi),
       labels = expression(0, pi / 4, pi / 2, 3 * pi / 4, pi))
  axis(2); box()
  abline(h = c(0, 1), lty = 2)
  lines(th, A_theta_x(theta = th, x = x, p = 3), col = 2)
  lines(th, A_theta_x(theta = th, x = x, p = 4), col = 3)
  lines(th, A_theta_x(theta = th, x = x, p = 5), col = 4)
  legend("top", lwd = 2, legend = paste("p =", 2:5),
         col = 1:4, cex = 0.75, horiz = TRUE)

}
old_par <- par(mfrow = c(2, 3))
A_lines(x = -0.75)
A_lines(x = -0.25)
A_lines(x = 0)
A_lines(x = 0.25)
A_lines(x = 0.5)
A_lines(x = 0.75)
par(old_par)

# As surface of (theta, x) for several dimensions
A_surf <- function(p, x = seq(-1, 1, l = 201), th = seq(0, pi, l = 201)) {

  col <- c("white", viridisLite::viridis(20))
  breaks <- c(-1, seq(1e-15, 1, l = 21))
  A <- A_theta_x(theta = th, x = x, p = p)
  image(th, x, A, main = paste("p =", p), col = col, breaks = breaks,
        xlab = expression(theta), axes = FALSE)
  axis(1, at = c(0, pi / 4, pi / 2, 3 * pi / 4, pi),
       labels = expression(0, pi / 4, pi / 2, 3 * pi / 4, pi))
  axis(2); box()
  contour(th, x, A, levels = breaks, add = TRUE)

}
old_par <- par(mfrow = c(2, 2))
A_surf(p = 2)
A_surf(p = 3)
A_surf(p = 4)
A_surf(p = 5)
par(old_par)

# No matrix return
th <- seq(0, pi, l = 5)
x <- seq(-1, 1, l = 5)
diag(A_theta_x(theta = th, x = x, p = 2))
A_theta_x(theta = th, x = x, p = 2, as_matrix = FALSE)
}
\references{
García-Portugués, E., Navarro-Esteban, P., Cuesta-Albertos, J. A. (2020)
On a projection-based class of uniformity tests on the hypersphere.
\emph{arXiv:2008.09897}. \url{https://arxiv.org/abs/2008.09897}
}
