% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiR.R
\name{spir_data}
\alias{spir_data}
\title{spir_data}
\usage{
spir_data(country = spi_country, years = spi_year, indicators = spi_indicator)
}
\arguments{
\item{country}{Countries' ISO code.}

\item{years}{Years for which you want data.}

\item{indicators}{Indicators from the Social Progress Index.}
}
\value{
Data for the country, indicator and year requested.
}
\description{
This function allows you to find and display the Social Progress Index data according to the selected parameters.
If no arguments are filled, all data will be displayed.
}
\examples{
myData<- spir_data(country = c("USA", "FRA"), years = "2018", )
myData<- spir_data(country = c("USA", "FRA"), year = c("2018", "2019"), indicators = "SPI")
myData<- spir_data("USA", "2019", c("SPI", "FOW"))
myData<- spir_data(, "2018", )
myData<- spir_data("USA", "2017", )
myData<- spir_data("USA", , )
myData<- spir_data(, , )
myData<- spir_data()
}
\seealso{
\code{\link{spir_indicator}} for the SPI's indicator symbol and \code{\link{spir_country}} for the country's ISO code.
}
