% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minInDist.R
\name{minInDist}
\alias{minInDist}
\title{Nearest non-conspecific and maximum intra-specific distances}
\usage{
minInDist(distobj, sppVector = NULL, propZero = FALSE, rmNA = FALSE)
}
\arguments{
\item{distobj}{Distance matrix.}

\item{sppVector}{Species vector (see \code{\link{sppVector}}). Default of
NULL.}

\item{propZero}{Logical. TRUE gives the proportion of zero distances.}

\item{rmNA}{Logical. TRUE ignores missing values in the distance matrix.
Default of FALSE}
}
\value{
If \code{propZero=FALSE}, a numeric vector giving the distance of
the closest non-conspecific individual (\code{nonConDist}) or the most
distant conspecific individual (\code{maxInDist}).

If \code{propZero=TRUE}, a single number giving the proportion of zero
distances.
}
\description{
These functions give the distances to the nearest non-conspecific and
furthest conspecific representatives for each individual in the dataset.
}
\details{
\code{nonConDist} returns the minimum inter-specific distance for each
individual.

\code{maxInDist} returns the maximum intra-specific distance for each
individual.

These two functions can be used to create a version of the barcoding gap.

\code{minInDist} returns the minimum intra-specific distance for each
individual.
}
\examples{

data(anoteropsis)
anoDist <- ape::dist.dna(anoteropsis)
anoSpp <- sapply(strsplit(dimnames(anoteropsis)[[1]], split="_"), 
    function(x) paste(x[1], x[2], sep="_"))

nonConDist(anoDist, anoSpp)
nonConDist(anoDist, anoSpp, propZero=TRUE)

maxInDist(anoDist, anoSpp)
maxInDist(anoDist, anoSpp, propZero=TRUE)

#Barcoding gap
inter <- nonConDist(anoDist, anoSpp)
intra <- maxInDist(anoDist, anoSpp)
graphics::hist(inter-intra)

#An alternative way of plotting the gap
bnd <- cbind(data.frame(inter, intra))
ord <- bnd[order(bnd$inter),]
graphics::plot(ord$inter, type="n", ylab="Percent K2P distance", xlab="Individual")
segCol <- rep("gray50", length(ord$inter))
segCol[ord$inter-ord$intra < 0] <- "red"
graphics::segments(x0=1:length(ord$inter), y0=ord$inter, y1=ord$intra, col=segCol, lwd=6)

}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Barcoding}
