% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.slidWin.R
\name{plot.slidWin}
\alias{plot.slidWin}
\title{Plot a 'slidWin' object}
\usage{
\method{plot}{slidWin}(x, outliers = FALSE, ...)
}
\arguments{
\item{x}{An object of class `slidWin'.}

\item{outliers}{Logical. When the results of \code{\link{slideBoxplots}} are
being called, should the outliers be plotted? Default of FALSE.}

\item{...}{Other arguments to be passed to \code{plot}.}
}
\value{
Plots graphs depending on the options given to
\code{\link{slideAnalyses}} or \code{\link{slideBoxplots}}.
}
\description{
Graphical representation of the summary statistics derived from
\code{\link{slideAnalyses}} and \code{\link{slideBoxplots}}
}
\details{
When boxplots of methods \code{nonCon} and \code{interAll}, the y-axis
limits are constrained to the midpoint of the range covered by the boxplots,
so that the intra-specific variation can be seen.
}
\examples{

data(dolomedes)
doloSpp <- substr(dimnames(dolomedes)[[1]], 1, 5)

doloSlide <- slideAnalyses(dolomedes,  doloSpp, 200, interval=10, treeMeasures=TRUE)

graphics::plot(doloSlide)

doloBox <- slideBoxplots(dolomedes,  doloSpp, 200, interval=10, method="overall")

graphics::plot(doloBox)


data(anoteropsis)
anoSpp <- sapply(strsplit(dimnames(anoteropsis)[[1]], split="_"), 
    function(x) paste(x[1], x[2], sep="_"))

anoBox <- slideBoxplots(anoteropsis,  anoSpp, 200, interval=10, method="interAll")

graphics::plot(anoBox)
graphics::plot(anoBox, outliers=TRUE)


}
\seealso{
\code{\link{slideAnalyses}}, \code{\link{slideBoxplots}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Sliding}
\keyword{window}
