% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqStat.R
\name{seqStat}
\alias{seqStat}
\title{Sequence statistics}
\usage{
seqStat(DNAbin, thresh = 500)
}
\arguments{
\item{DNAbin}{Alignment of class `DNAbin'.}

\item{thresh}{Threshold sequence length. Default of 500 (minimum length for
official DNA barcodes).}
}
\value{
A table giving the minimum, maximum, mean and median sequence
lengths, and the number of sequences with lengths below the given threshold.
}
\description{
Utility that produces a table giving summary statistics for a `DNAbin'
object.
}
\details{
This function considers bases coded as '?', 'N' and '-' as missing data.
}
\examples{

data(anoteropsis)
seqStat(anoteropsis)

}
\author{
Rupert Collins <rupertcollins@gmail.com>
}
\keyword{Barcoding}
\keyword{Utilities}
