% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_render.r
\name{render_gganimate}
\alias{render_gganimate}
\title{Render the slides as a \emph{gganimate} animation}
\usage{
render_gganimate(fps = 3, rewind = FALSE, start_pause = 1, end_pause = 3, ...)
}
\arguments{
\item{fps}{Frames/slides shown per second. Defaults to 3.}

\item{rewind}{Play the animation backwards after reaching the end?
Default to FALSE.}

\item{start_pause}{Number of seconds to pause on the first frame for.
Defaults to 1.}

\item{end_pause}{Number of seconds to pause on the last frame for.
Defaults to 3.}

\item{...}{Optional, pass addition arguments to
\code{gganimate::transition_states()}.}
}
\description{
Takes the result of \code{array2df()} and renders them into a
\emph{gganimate} animation.
}
\examples{
\dontrun{
flea_std <- tourr::rescale(tourr::flea[, 1:6])

rb <- tourr::basis_random(n = ncol(flea_std))
mtour <- manual_tour(basis = rb, manip_var = 4)
sshow <- array2df(array = mtour, data = flea_std)
render_gganimate(slides = sshow)

render_gganimate(slides = sshow, axes = "bottomleft", fps = 2, rewind = TRUE,
  col = tourr::flea$species, pch = tourr::flea$species, size = 2, alpha = .6)
}
}
