% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbinaryGMM.R
\name{getSummary.bingmm}
\alias{getSummary.bingmm}
\title{Get Model Summaries for use with "mtable" for objects of class bingmm}
\usage{
\method{getSummary}{bingmm}(
  obj,
  alpha = 0.05,
  vce = c("robust", "efficient", "ml"),
  method = "bhhh",
  R = 1000,
  ...
)
}
\arguments{
\item{obj}{a \code{bingmm} object,}

\item{alpha}{level of the confidence intervals,}

\item{vce}{string indicating what kind of standard errors should be computed when using \code{summary}. For the one-step GMM estimator, the options are \code{"robust"} and \code{"ml"}. For the two-step GMM estimator, the options are \code{"robust"}, \code{"efficient"} and \code{"ml"}. The option \code{"vce = ml"} is an exploratory method that evaluates the VC of the RIS estimator using the GMM estimates.}

\item{method}{only valid if \code{vce = "ml"}. It indicates the algorithm used to compute the Hessian matrix of the RIS estimator. The defult is \code{"bhhh"}.}

\item{R}{only valid if \code{vce = "ml"}. It indicates the number of draws used to compute the simulated probability in the RIS estimator.}

\item{...}{further arguments,}
}
\value{
A list with an array with coefficient estimates and a vector containing the model summary statistics.
}
\description{
A generic function to collect coefficients and summary statistics from a \code{bingmm} object. It is used in \code{mtable}
}
\details{
For more details see package \pkg{memisc}.
}
