% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{DPdata}
\alias{DPdata}
\title{Generated dataset of Dot-probe data}
\format{A dataframe with 3840 rows and 6 variables
\itemize{
\item subject: contains participant numbers for 20 subjects
\item blockcode: two block conditions "block1" and "block2"
\item trialnum: 96 trials per block
\item congruency: sets to congruent or incongruent trials
\item latency: RT measure (simulated data)
\item correct: accuracy (set to all accurate for the example)
}}
\usage{
DPdata
}
\description{
A dataset containing data necessary to run examples of each function
}
\details{
The following code was used to generate the data

DPdata <- data.frame(subject = rep(1:20, each = (96*2)),
blockcode = rep(c("block1","block2"), each = 96, length.out = 20*2*96),
trialnum = rep(1:96, length.out = 20*2*96),
congruency = rep(c("Congruent","Incongruent"), length.out = 20*2*96),
latency = rep(rnorm(100,25), length.out = 20*2*96),
correct = rep(1, length.out = 20*2*96))
}
\keyword{datasets}
