% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splithalf_diff_diff.R
\name{splithalf_diff_diff}
\alias{splithalf_diff_diff}
\title{Split Half for difference scores of difference scores}
\usage{
splithalf_diff_diff(data, RTmintrim = "none", RTmaxtrim = "none",
  incErrors = FALSE, condition1 = "Assessment1",
  condition2 = "Assessment2", halftype = "random", no.iterations = 5000,
  var.RT = "latency", var.condition = FALSE, var.participant = "subject",
  var.correct = "correct", var.trialnum = "trialnum",
  var.compare = "congruency", compare1 = "Congruent",
  compare2 = "Incongruent", removelist = "", average = "mean",
  sdtrim = FALSE)
}
\arguments{
\item{data}{specifies the raw dataset to be processed}

\item{RTmintrim}{specifies the lower cut-off point for RTs}

\item{RTmaxtrim}{specifies the maximum cut-off point for RTs}

\item{incErrors}{include incorrect trials?, defaults to FALSE}

\item{condition1}{specifies the first condition}

\item{condition2}{specifies the second condition}

\item{halftype}{specifies the split method; "oddeven", "halfs", or "random"}

\item{no.iterations}{specifies the number of random splits to run}

\item{var.RT}{specifies the RT variable name in data}

\item{var.condition}{specifies the condition variable name in data - if not specified then splithalf will treat all trials as one condition}

\item{var.participant}{specifies the subject variable name in data}

\item{var.correct}{specifies the accuracy variable name in data}

\item{var.trialnum}{specifies the trial number variable}

\item{var.compare}{specified the variable that is used to calculate difference scores (e.g. including congruent and incongruent trials)}

\item{compare1}{specifies the first trial type to be compared (e.g. congruent trials)}

\item{compare2}{specifies the first trial type to be compared (e.g. incongruent trials)}

\item{removelist}{specifies a list of participants to be removed}

\item{average}{allows the user to specify whether mean or median will be used to create the bias index}

\item{sdtrim}{allows the user to trim the data by selected sd (after removal of errors and min/max RTs)}
}
\value{
Returns a data frame containing split-half reliability estimates for the bias index in each condition specified.

splithalf returns the raw estimate of the bias index

spearmanbrown returns the spearman-brown corrected estimate of the bias index

Warning: If there are missing data (e.g one condition data missing for one participant) output will include details of the missing data and return a dataframe containing the NA data. Warnings will be displayed in the console.
}
\description{
This function calculates split half reliability estimates for Dot Probe data
}
\examples{
## split half estimates for the bias index in two blocks
## using 50 iterations of the random split method (note: 5000 would be standard)
# not run:
# splithalf_diff(DPdata, conditionlist = c("block1","block2"),
# halftype = "random", no.iterations = 50)
## In datasets with missing data an additional output is generated
## the console will return a list of participants/blocks
## the output will also include a full dataframe of missing values
# not run:
# splithalf_diff(DPdata_missing, conditionlist = c("block1","block2"),
# halftype = "random", no.iterations = 50)
}
