% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{stratify}
\alias{stratify}
\title{Stratify a data frame}
\usage{
stratify(ds, stratification = NULL)
}
\arguments{
\item{ds}{(data frame) data to split into strata}

\item{stratification}{(vector). Vector that identifies which subsets of
\code{data} should be split separately (denoted as strata in splitting
functions) in order to ensure they are evenly distributed between patrs. 
If NULL, all \code{data} is considered a single stratum.}
}
\value{
(list) List of strata
}
\description{
Split a dataframe into strata formed by each a unique value of \code{stratification}.
}
\examples{
# Stratify a data frame, then split it odd-even
ds <- data.frame(condition = rep(c("a", "b"), each = 4), score = 1 : 8)
strata <- stratify(ds, ds$condition)
split_strata(strata, method = "odd_even")
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_strata}()},
\code{\link{apply_split_indexes_to_stratum}()},
\code{\link{check_strata}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{get_split_indexes_from_stratum}()},
\code{\link{split_df}()},
\code{\link{split_strata}()},
\code{\link{split_stratum}()}
}
\concept{splitting functions}
